/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.lexmodelbuilding.model.ExportType;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.ResourceType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetExportRequest
extends LexModelBuildingRequest
implements ToCopyableBuilder<Builder, GetExportRequest> {
    private final String name;
    private final String version;
    private final String resourceType;
    private final String exportType;

    private GetExportRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.version = builder.version;
        this.resourceType = builder.resourceType;
        this.exportType = builder.exportType;
    }

    public String name() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    public ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeString() {
        return this.resourceType;
    }

    public ExportType exportType() {
        return ExportType.fromValue(this.exportType);
    }

    public String exportTypeString() {
        return this.exportType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportTypeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExportRequest)) {
            return false;
        }
        GetExportRequest other = (GetExportRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.resourceTypeString(), other.resourceTypeString()) && Objects.equals(this.exportTypeString(), other.exportTypeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        if (this.resourceTypeString() != null) {
            sb.append("ResourceType: ").append(this.resourceTypeString()).append(",");
        }
        if (this.exportTypeString() != null) {
            sb.append("ExportType: ").append(this.exportTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "version": {
                return Optional.of(clazz.cast(this.version()));
            }
            case "resourceType": {
                return Optional.of(clazz.cast(this.resourceTypeString()));
            }
            case "exportType": {
                return Optional.of(clazz.cast(this.exportTypeString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LexModelBuildingRequest.BuilderImpl
    implements Builder {
        private String name;
        private String version;
        private String resourceType;
        private String exportType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExportRequest model) {
            this.name(model.name);
            this.version(model.version);
            this.resourceType(model.resourceType);
            this.exportType(model.exportType);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getExportType() {
            return this.exportType;
        }

        @Override
        public final Builder exportType(String exportType) {
            this.exportType = exportType;
            return this;
        }

        @Override
        public final Builder exportType(ExportType exportType) {
            this.exportType(exportType.toString());
            return this;
        }

        public final void setExportType(String exportType) {
            this.exportType = exportType;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetExportRequest build() {
            return new GetExportRequest(this);
        }
    }

    public static interface Builder
    extends LexModelBuildingRequest.Builder,
    CopyableBuilder<Builder, GetExportRequest> {
        public Builder name(String var1);

        public Builder version(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder exportType(String var1);

        public Builder exportType(ExportType var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

