/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.lexmodelbuilding.model.CodeHook;
import software.amazon.awssdk.services.lexmodelbuilding.model.FollowUpPrompt;
import software.amazon.awssdk.services.lexmodelbuilding.model.FulfillmentActivity;
import software.amazon.awssdk.services.lexmodelbuilding.model.IntentUtteranceListCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.Prompt;
import software.amazon.awssdk.services.lexmodelbuilding.model.Slot;
import software.amazon.awssdk.services.lexmodelbuilding.model.SlotListCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.Statement;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetIntentResponse
extends LexModelBuildingResponse
implements ToCopyableBuilder<Builder, GetIntentResponse> {
    private final String name;
    private final String description;
    private final List<Slot> slots;
    private final List<String> sampleUtterances;
    private final Prompt confirmationPrompt;
    private final Statement rejectionStatement;
    private final FollowUpPrompt followUpPrompt;
    private final Statement conclusionStatement;
    private final CodeHook dialogCodeHook;
    private final FulfillmentActivity fulfillmentActivity;
    private final String parentIntentSignature;
    private final Instant lastUpdatedDate;
    private final Instant createdDate;
    private final String version;
    private final String checksum;

    private GetIntentResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.slots = builder.slots;
        this.sampleUtterances = builder.sampleUtterances;
        this.confirmationPrompt = builder.confirmationPrompt;
        this.rejectionStatement = builder.rejectionStatement;
        this.followUpPrompt = builder.followUpPrompt;
        this.conclusionStatement = builder.conclusionStatement;
        this.dialogCodeHook = builder.dialogCodeHook;
        this.fulfillmentActivity = builder.fulfillmentActivity;
        this.parentIntentSignature = builder.parentIntentSignature;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.createdDate = builder.createdDate;
        this.version = builder.version;
        this.checksum = builder.checksum;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public List<Slot> slots() {
        return this.slots;
    }

    public List<String> sampleUtterances() {
        return this.sampleUtterances;
    }

    public Prompt confirmationPrompt() {
        return this.confirmationPrompt;
    }

    public Statement rejectionStatement() {
        return this.rejectionStatement;
    }

    public FollowUpPrompt followUpPrompt() {
        return this.followUpPrompt;
    }

    public Statement conclusionStatement() {
        return this.conclusionStatement;
    }

    public CodeHook dialogCodeHook() {
        return this.dialogCodeHook;
    }

    public FulfillmentActivity fulfillmentActivity() {
        return this.fulfillmentActivity;
    }

    public String parentIntentSignature() {
        return this.parentIntentSignature;
    }

    public Instant lastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public String version() {
        return this.version;
    }

    public String checksum() {
        return this.checksum;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.slots());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleUtterances());
        hashCode = 31 * hashCode + Objects.hashCode(this.confirmationPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(this.rejectionStatement());
        hashCode = 31 * hashCode + Objects.hashCode(this.followUpPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(this.conclusionStatement());
        hashCode = 31 * hashCode + Objects.hashCode(this.dialogCodeHook());
        hashCode = 31 * hashCode + Objects.hashCode(this.fulfillmentActivity());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentIntentSignature());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksum());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIntentResponse)) {
            return false;
        }
        GetIntentResponse other = (GetIntentResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.slots(), other.slots()) && Objects.equals(this.sampleUtterances(), other.sampleUtterances()) && Objects.equals(this.confirmationPrompt(), other.confirmationPrompt()) && Objects.equals(this.rejectionStatement(), other.rejectionStatement()) && Objects.equals(this.followUpPrompt(), other.followUpPrompt()) && Objects.equals(this.conclusionStatement(), other.conclusionStatement()) && Objects.equals(this.dialogCodeHook(), other.dialogCodeHook()) && Objects.equals(this.fulfillmentActivity(), other.fulfillmentActivity()) && Objects.equals(this.parentIntentSignature(), other.parentIntentSignature()) && Objects.equals(this.lastUpdatedDate(), other.lastUpdatedDate()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.checksum(), other.checksum());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.slots() != null) {
            sb.append("Slots: ").append(this.slots()).append(",");
        }
        if (this.sampleUtterances() != null) {
            sb.append("SampleUtterances: ").append(this.sampleUtterances()).append(",");
        }
        if (this.confirmationPrompt() != null) {
            sb.append("ConfirmationPrompt: ").append(this.confirmationPrompt()).append(",");
        }
        if (this.rejectionStatement() != null) {
            sb.append("RejectionStatement: ").append(this.rejectionStatement()).append(",");
        }
        if (this.followUpPrompt() != null) {
            sb.append("FollowUpPrompt: ").append(this.followUpPrompt()).append(",");
        }
        if (this.conclusionStatement() != null) {
            sb.append("ConclusionStatement: ").append(this.conclusionStatement()).append(",");
        }
        if (this.dialogCodeHook() != null) {
            sb.append("DialogCodeHook: ").append(this.dialogCodeHook()).append(",");
        }
        if (this.fulfillmentActivity() != null) {
            sb.append("FulfillmentActivity: ").append(this.fulfillmentActivity()).append(",");
        }
        if (this.parentIntentSignature() != null) {
            sb.append("ParentIntentSignature: ").append(this.parentIntentSignature()).append(",");
        }
        if (this.lastUpdatedDate() != null) {
            sb.append("LastUpdatedDate: ").append(this.lastUpdatedDate()).append(",");
        }
        if (this.createdDate() != null) {
            sb.append("CreatedDate: ").append(this.createdDate()).append(",");
        }
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        if (this.checksum() != null) {
            sb.append("Checksum: ").append(this.checksum()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "slots": {
                return Optional.of(clazz.cast(this.slots()));
            }
            case "sampleUtterances": {
                return Optional.of(clazz.cast(this.sampleUtterances()));
            }
            case "confirmationPrompt": {
                return Optional.of(clazz.cast(this.confirmationPrompt()));
            }
            case "rejectionStatement": {
                return Optional.of(clazz.cast(this.rejectionStatement()));
            }
            case "followUpPrompt": {
                return Optional.of(clazz.cast(this.followUpPrompt()));
            }
            case "conclusionStatement": {
                return Optional.of(clazz.cast(this.conclusionStatement()));
            }
            case "dialogCodeHook": {
                return Optional.of(clazz.cast(this.dialogCodeHook()));
            }
            case "fulfillmentActivity": {
                return Optional.of(clazz.cast(this.fulfillmentActivity()));
            }
            case "parentIntentSignature": {
                return Optional.of(clazz.cast(this.parentIntentSignature()));
            }
            case "lastUpdatedDate": {
                return Optional.of(clazz.cast(this.lastUpdatedDate()));
            }
            case "createdDate": {
                return Optional.of(clazz.cast(this.createdDate()));
            }
            case "version": {
                return Optional.of(clazz.cast(this.version()));
            }
            case "checksum": {
                return Optional.of(clazz.cast(this.checksum()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LexModelBuildingResponse.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<Slot> slots;
        private List<String> sampleUtterances;
        private Prompt confirmationPrompt;
        private Statement rejectionStatement;
        private FollowUpPrompt followUpPrompt;
        private Statement conclusionStatement;
        private CodeHook dialogCodeHook;
        private FulfillmentActivity fulfillmentActivity;
        private String parentIntentSignature;
        private Instant lastUpdatedDate;
        private Instant createdDate;
        private String version;
        private String checksum;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIntentResponse model) {
            this.name(model.name);
            this.description(model.description);
            this.slots(model.slots);
            this.sampleUtterances(model.sampleUtterances);
            this.confirmationPrompt(model.confirmationPrompt);
            this.rejectionStatement(model.rejectionStatement);
            this.followUpPrompt(model.followUpPrompt);
            this.conclusionStatement(model.conclusionStatement);
            this.dialogCodeHook(model.dialogCodeHook);
            this.fulfillmentActivity(model.fulfillmentActivity);
            this.parentIntentSignature(model.parentIntentSignature);
            this.lastUpdatedDate(model.lastUpdatedDate);
            this.createdDate(model.createdDate);
            this.version(model.version);
            this.checksum(model.checksum);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Slot.Builder> getSlots() {
            return this.slots != null ? (Collection)this.slots.stream().map(Slot::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder slots(Collection<Slot> slots) {
            this.slots = SlotListCopier.copy(slots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slots(Slot ... slots) {
            this.slots(Arrays.asList(slots));
            return this;
        }

        public final void setSlots(Collection<Slot.BuilderImpl> slots) {
            this.slots = SlotListCopier.copyFromBuilder(slots);
        }

        public final Collection<String> getSampleUtterances() {
            return this.sampleUtterances;
        }

        @Override
        public final Builder sampleUtterances(Collection<String> sampleUtterances) {
            this.sampleUtterances = IntentUtteranceListCopier.copy(sampleUtterances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleUtterances(String ... sampleUtterances) {
            this.sampleUtterances(Arrays.asList(sampleUtterances));
            return this;
        }

        public final void setSampleUtterances(Collection<String> sampleUtterances) {
            this.sampleUtterances = IntentUtteranceListCopier.copy(sampleUtterances);
        }

        public final Prompt.Builder getConfirmationPrompt() {
            return this.confirmationPrompt != null ? this.confirmationPrompt.toBuilder() : null;
        }

        @Override
        public final Builder confirmationPrompt(Prompt confirmationPrompt) {
            this.confirmationPrompt = confirmationPrompt;
            return this;
        }

        public final void setConfirmationPrompt(Prompt.BuilderImpl confirmationPrompt) {
            this.confirmationPrompt = confirmationPrompt != null ? confirmationPrompt.build() : null;
        }

        public final Statement.Builder getRejectionStatement() {
            return this.rejectionStatement != null ? this.rejectionStatement.toBuilder() : null;
        }

        @Override
        public final Builder rejectionStatement(Statement rejectionStatement) {
            this.rejectionStatement = rejectionStatement;
            return this;
        }

        public final void setRejectionStatement(Statement.BuilderImpl rejectionStatement) {
            this.rejectionStatement = rejectionStatement != null ? rejectionStatement.build() : null;
        }

        public final FollowUpPrompt.Builder getFollowUpPrompt() {
            return this.followUpPrompt != null ? this.followUpPrompt.toBuilder() : null;
        }

        @Override
        public final Builder followUpPrompt(FollowUpPrompt followUpPrompt) {
            this.followUpPrompt = followUpPrompt;
            return this;
        }

        public final void setFollowUpPrompt(FollowUpPrompt.BuilderImpl followUpPrompt) {
            this.followUpPrompt = followUpPrompt != null ? followUpPrompt.build() : null;
        }

        public final Statement.Builder getConclusionStatement() {
            return this.conclusionStatement != null ? this.conclusionStatement.toBuilder() : null;
        }

        @Override
        public final Builder conclusionStatement(Statement conclusionStatement) {
            this.conclusionStatement = conclusionStatement;
            return this;
        }

        public final void setConclusionStatement(Statement.BuilderImpl conclusionStatement) {
            this.conclusionStatement = conclusionStatement != null ? conclusionStatement.build() : null;
        }

        public final CodeHook.Builder getDialogCodeHook() {
            return this.dialogCodeHook != null ? this.dialogCodeHook.toBuilder() : null;
        }

        @Override
        public final Builder dialogCodeHook(CodeHook dialogCodeHook) {
            this.dialogCodeHook = dialogCodeHook;
            return this;
        }

        public final void setDialogCodeHook(CodeHook.BuilderImpl dialogCodeHook) {
            this.dialogCodeHook = dialogCodeHook != null ? dialogCodeHook.build() : null;
        }

        public final FulfillmentActivity.Builder getFulfillmentActivity() {
            return this.fulfillmentActivity != null ? this.fulfillmentActivity.toBuilder() : null;
        }

        @Override
        public final Builder fulfillmentActivity(FulfillmentActivity fulfillmentActivity) {
            this.fulfillmentActivity = fulfillmentActivity;
            return this;
        }

        public final void setFulfillmentActivity(FulfillmentActivity.BuilderImpl fulfillmentActivity) {
            this.fulfillmentActivity = fulfillmentActivity != null ? fulfillmentActivity.build() : null;
        }

        public final String getParentIntentSignature() {
            return this.parentIntentSignature;
        }

        @Override
        public final Builder parentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
            return this;
        }

        public final void setParentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
        }

        public final Instant getLastUpdatedDate() {
            return this.lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getChecksum() {
            return this.checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        @Override
        public GetIntentResponse build() {
            return new GetIntentResponse(this);
        }
    }

    public static interface Builder
    extends LexModelBuildingResponse.Builder,
    CopyableBuilder<Builder, GetIntentResponse> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder slots(Collection<Slot> var1);

        public Builder slots(Slot ... var1);

        public Builder sampleUtterances(Collection<String> var1);

        public Builder sampleUtterances(String ... var1);

        public Builder confirmationPrompt(Prompt var1);

        default public Builder confirmationPrompt(Consumer<Prompt.Builder> confirmationPrompt) {
            return this.confirmationPrompt((Prompt)((Prompt.Builder)Prompt.builder().apply(confirmationPrompt)).build());
        }

        public Builder rejectionStatement(Statement var1);

        default public Builder rejectionStatement(Consumer<Statement.Builder> rejectionStatement) {
            return this.rejectionStatement((Statement)((Statement.Builder)Statement.builder().apply(rejectionStatement)).build());
        }

        public Builder followUpPrompt(FollowUpPrompt var1);

        default public Builder followUpPrompt(Consumer<FollowUpPrompt.Builder> followUpPrompt) {
            return this.followUpPrompt((FollowUpPrompt)((FollowUpPrompt.Builder)FollowUpPrompt.builder().apply(followUpPrompt)).build());
        }

        public Builder conclusionStatement(Statement var1);

        default public Builder conclusionStatement(Consumer<Statement.Builder> conclusionStatement) {
            return this.conclusionStatement((Statement)((Statement.Builder)Statement.builder().apply(conclusionStatement)).build());
        }

        public Builder dialogCodeHook(CodeHook var1);

        default public Builder dialogCodeHook(Consumer<CodeHook.Builder> dialogCodeHook) {
            return this.dialogCodeHook((CodeHook)((CodeHook.Builder)CodeHook.builder().apply(dialogCodeHook)).build());
        }

        public Builder fulfillmentActivity(FulfillmentActivity var1);

        default public Builder fulfillmentActivity(Consumer<FulfillmentActivity.Builder> fulfillmentActivity) {
            return this.fulfillmentActivity((FulfillmentActivity)((FulfillmentActivity.Builder)FulfillmentActivity.builder().apply(fulfillmentActivity)).build());
        }

        public Builder parentIntentSignature(String var1);

        public Builder lastUpdatedDate(Instant var1);

        public Builder createdDate(Instant var1);

        public Builder version(String var1);

        public Builder checksum(String var1);
    }
}

