/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.ListsOfUtterancesCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.UtteranceList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetUtterancesViewResponse
extends LexModelBuildingResponse
implements ToCopyableBuilder<Builder, GetUtterancesViewResponse> {
    private final String botName;
    private final List<UtteranceList> utterances;

    private GetUtterancesViewResponse(BuilderImpl builder) {
        super(builder);
        this.botName = builder.botName;
        this.utterances = builder.utterances;
    }

    public String botName() {
        return this.botName;
    }

    public List<UtteranceList> utterances() {
        return this.utterances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.botName());
        hashCode = 31 * hashCode + Objects.hashCode(this.utterances());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUtterancesViewResponse)) {
            return false;
        }
        GetUtterancesViewResponse other = (GetUtterancesViewResponse)((Object)obj);
        return Objects.equals(this.botName(), other.botName()) && Objects.equals(this.utterances(), other.utterances());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.botName() != null) {
            sb.append("BotName: ").append(this.botName()).append(",");
        }
        if (this.utterances() != null) {
            sb.append("Utterances: ").append(this.utterances()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botName": {
                return Optional.of(clazz.cast(this.botName()));
            }
            case "utterances": {
                return Optional.of(clazz.cast(this.utterances()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LexModelBuildingResponse.BuilderImpl
    implements Builder {
        private String botName;
        private List<UtteranceList> utterances;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUtterancesViewResponse model) {
            this.botName(model.botName);
            this.utterances(model.utterances);
        }

        public final String getBotName() {
            return this.botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        public final Collection<UtteranceList.Builder> getUtterances() {
            return this.utterances != null ? (Collection)this.utterances.stream().map(UtteranceList::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder utterances(Collection<UtteranceList> utterances) {
            this.utterances = ListsOfUtterancesCopier.copy(utterances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utterances(UtteranceList ... utterances) {
            this.utterances(Arrays.asList(utterances));
            return this;
        }

        public final void setUtterances(Collection<UtteranceList.BuilderImpl> utterances) {
            this.utterances = ListsOfUtterancesCopier.copyFromBuilder(utterances);
        }

        @Override
        public GetUtterancesViewResponse build() {
            return new GetUtterancesViewResponse(this);
        }
    }

    public static interface Builder
    extends LexModelBuildingResponse.Builder,
    CopyableBuilder<Builder, GetUtterancesViewResponse> {
        public Builder botName(String var1);

        public Builder utterances(Collection<UtteranceList> var1);

        public Builder utterances(UtteranceList ... var1);
    }
}

