/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.lexmodelbuilding.model.EnumerationValue;
import software.amazon.awssdk.services.lexmodelbuilding.model.EnumerationValuesCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.SlotValueSelectionStrategy;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutSlotTypeRequest
extends LexModelBuildingRequest
implements ToCopyableBuilder<Builder, PutSlotTypeRequest> {
    private final String name;
    private final String description;
    private final List<EnumerationValue> enumerationValues;
    private final String checksum;
    private final String valueSelectionStrategy;

    private PutSlotTypeRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.enumerationValues = builder.enumerationValues;
        this.checksum = builder.checksum;
        this.valueSelectionStrategy = builder.valueSelectionStrategy;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public List<EnumerationValue> enumerationValues() {
        return this.enumerationValues;
    }

    public String checksum() {
        return this.checksum;
    }

    public SlotValueSelectionStrategy valueSelectionStrategy() {
        return SlotValueSelectionStrategy.fromValue(this.valueSelectionStrategy);
    }

    public String valueSelectionStrategyString() {
        return this.valueSelectionStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.enumerationValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueSelectionStrategyString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSlotTypeRequest)) {
            return false;
        }
        PutSlotTypeRequest other = (PutSlotTypeRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.enumerationValues(), other.enumerationValues()) && Objects.equals(this.checksum(), other.checksum()) && Objects.equals(this.valueSelectionStrategyString(), other.valueSelectionStrategyString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.enumerationValues() != null) {
            sb.append("EnumerationValues: ").append(this.enumerationValues()).append(",");
        }
        if (this.checksum() != null) {
            sb.append("Checksum: ").append(this.checksum()).append(",");
        }
        if (this.valueSelectionStrategyString() != null) {
            sb.append("ValueSelectionStrategy: ").append(this.valueSelectionStrategyString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "enumerationValues": {
                return Optional.of(clazz.cast(this.enumerationValues()));
            }
            case "checksum": {
                return Optional.of(clazz.cast(this.checksum()));
            }
            case "valueSelectionStrategy": {
                return Optional.of(clazz.cast(this.valueSelectionStrategyString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LexModelBuildingRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<EnumerationValue> enumerationValues;
        private String checksum;
        private String valueSelectionStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSlotTypeRequest model) {
            this.name(model.name);
            this.description(model.description);
            this.enumerationValues(model.enumerationValues);
            this.checksum(model.checksum);
            this.valueSelectionStrategy(model.valueSelectionStrategy);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<EnumerationValue.Builder> getEnumerationValues() {
            return this.enumerationValues != null ? (Collection)this.enumerationValues.stream().map(EnumerationValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder enumerationValues(Collection<EnumerationValue> enumerationValues) {
            this.enumerationValues = EnumerationValuesCopier.copy(enumerationValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enumerationValues(EnumerationValue ... enumerationValues) {
            this.enumerationValues(Arrays.asList(enumerationValues));
            return this;
        }

        public final void setEnumerationValues(Collection<EnumerationValue.BuilderImpl> enumerationValues) {
            this.enumerationValues = EnumerationValuesCopier.copyFromBuilder(enumerationValues);
        }

        public final String getChecksum() {
            return this.checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public final String getValueSelectionStrategy() {
            return this.valueSelectionStrategy;
        }

        @Override
        public final Builder valueSelectionStrategy(String valueSelectionStrategy) {
            this.valueSelectionStrategy = valueSelectionStrategy;
            return this;
        }

        @Override
        public final Builder valueSelectionStrategy(SlotValueSelectionStrategy valueSelectionStrategy) {
            this.valueSelectionStrategy(valueSelectionStrategy.toString());
            return this;
        }

        public final void setValueSelectionStrategy(String valueSelectionStrategy) {
            this.valueSelectionStrategy = valueSelectionStrategy;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutSlotTypeRequest build() {
            return new PutSlotTypeRequest(this);
        }
    }

    public static interface Builder
    extends LexModelBuildingRequest.Builder,
    CopyableBuilder<Builder, PutSlotTypeRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder enumerationValues(Collection<EnumerationValue> var1);

        public Builder enumerationValues(EnumerationValue ... var1);

        public Builder checksum(String var1);

        public Builder valueSelectionStrategy(String var1);

        public Builder valueSelectionStrategy(SlotValueSelectionStrategy var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

