/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotAliasesRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotAliasesResponse;

public final class GetBotAliasesPaginator
implements SdkIterable<GetBotAliasesResponse> {
    private final LexModelBuildingClient client;
    private final GetBotAliasesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetBotAliasesPaginator(LexModelBuildingClient client, GetBotAliasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetBotAliasesResponseFetcher();
    }

    public Iterator<GetBotAliasesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class GetBotAliasesResponseFetcher
    implements NextPageFetcher<GetBotAliasesResponse> {
        private GetBotAliasesResponseFetcher() {
        }

        public boolean hasNextPage(GetBotAliasesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetBotAliasesResponse nextPage(GetBotAliasesResponse previousPage) {
            if (previousPage == null) {
                return GetBotAliasesPaginator.this.client.getBotAliases(GetBotAliasesPaginator.this.firstRequest);
            }
            return GetBotAliasesPaginator.this.client.getBotAliases((GetBotAliasesRequest)((Object)GetBotAliasesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

