/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotVersionsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotVersionsResponse;

public final class GetBotVersionsPaginator
implements SdkIterable<GetBotVersionsResponse> {
    private final LexModelBuildingClient client;
    private final GetBotVersionsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetBotVersionsPaginator(LexModelBuildingClient client, GetBotVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetBotVersionsResponseFetcher();
    }

    public Iterator<GetBotVersionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class GetBotVersionsResponseFetcher
    implements NextPageFetcher<GetBotVersionsResponse> {
        private GetBotVersionsResponseFetcher() {
        }

        public boolean hasNextPage(GetBotVersionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetBotVersionsResponse nextPage(GetBotVersionsResponse previousPage) {
            if (previousPage == null) {
                return GetBotVersionsPaginator.this.client.getBotVersions(GetBotVersionsPaginator.this.firstRequest);
            }
            return GetBotVersionsPaginator.this.client.getBotVersions((GetBotVersionsRequest)((Object)GetBotVersionsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

