/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotsResponse;

public final class GetBotsPaginator
implements SdkIterable<GetBotsResponse> {
    private final LexModelBuildingClient client;
    private final GetBotsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetBotsPaginator(LexModelBuildingClient client, GetBotsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetBotsResponseFetcher();
    }

    public Iterator<GetBotsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class GetBotsResponseFetcher
    implements NextPageFetcher<GetBotsResponse> {
        private GetBotsResponseFetcher() {
        }

        public boolean hasNextPage(GetBotsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetBotsResponse nextPage(GetBotsResponse previousPage) {
            if (previousPage == null) {
                return GetBotsPaginator.this.client.getBots(GetBotsPaginator.this.firstRequest);
            }
            return GetBotsPaginator.this.client.getBots((GetBotsRequest)((Object)GetBotsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

