/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinSlotTypesResponse;

public final class GetBuiltinSlotTypesPaginator
implements SdkIterable<GetBuiltinSlotTypesResponse> {
    private final LexModelBuildingClient client;
    private final GetBuiltinSlotTypesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetBuiltinSlotTypesPaginator(LexModelBuildingClient client, GetBuiltinSlotTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetBuiltinSlotTypesResponseFetcher();
    }

    public Iterator<GetBuiltinSlotTypesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class GetBuiltinSlotTypesResponseFetcher
    implements NextPageFetcher<GetBuiltinSlotTypesResponse> {
        private GetBuiltinSlotTypesResponseFetcher() {
        }

        public boolean hasNextPage(GetBuiltinSlotTypesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetBuiltinSlotTypesResponse nextPage(GetBuiltinSlotTypesResponse previousPage) {
            if (previousPage == null) {
                return GetBuiltinSlotTypesPaginator.this.client.getBuiltinSlotTypes(GetBuiltinSlotTypesPaginator.this.firstRequest);
            }
            return GetBuiltinSlotTypesPaginator.this.client.getBuiltinSlotTypes((GetBuiltinSlotTypesRequest)((Object)GetBuiltinSlotTypesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

