/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentVersionsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentVersionsResponse;

public final class GetIntentVersionsPaginator
implements SdkIterable<GetIntentVersionsResponse> {
    private final LexModelBuildingClient client;
    private final GetIntentVersionsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetIntentVersionsPaginator(LexModelBuildingClient client, GetIntentVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetIntentVersionsResponseFetcher();
    }

    public Iterator<GetIntentVersionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class GetIntentVersionsResponseFetcher
    implements NextPageFetcher<GetIntentVersionsResponse> {
        private GetIntentVersionsResponseFetcher() {
        }

        public boolean hasNextPage(GetIntentVersionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetIntentVersionsResponse nextPage(GetIntentVersionsResponse previousPage) {
            if (previousPage == null) {
                return GetIntentVersionsPaginator.this.client.getIntentVersions(GetIntentVersionsPaginator.this.firstRequest);
            }
            return GetIntentVersionsPaginator.this.client.getIntentVersions((GetIntentVersionsRequest)((Object)GetIntentVersionsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

