/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypeVersionsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypeVersionsResponse;

public final class GetSlotTypeVersionsPaginator
implements SdkIterable<GetSlotTypeVersionsResponse> {
    private final LexModelBuildingClient client;
    private final GetSlotTypeVersionsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetSlotTypeVersionsPaginator(LexModelBuildingClient client, GetSlotTypeVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetSlotTypeVersionsResponseFetcher();
    }

    public Iterator<GetSlotTypeVersionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class GetSlotTypeVersionsResponseFetcher
    implements NextPageFetcher<GetSlotTypeVersionsResponse> {
        private GetSlotTypeVersionsResponseFetcher() {
        }

        public boolean hasNextPage(GetSlotTypeVersionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetSlotTypeVersionsResponse nextPage(GetSlotTypeVersionsResponse previousPage) {
            if (previousPage == null) {
                return GetSlotTypeVersionsPaginator.this.client.getSlotTypeVersions(GetSlotTypeVersionsPaginator.this.firstRequest);
            }
            return GetSlotTypeVersionsPaginator.this.client.getSlotTypeVersions((GetSlotTypeVersionsRequest)((Object)GetSlotTypeVersionsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

