/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypesResponse;

public final class GetSlotTypesPaginator
implements SdkIterable<GetSlotTypesResponse> {
    private final LexModelBuildingClient client;
    private final GetSlotTypesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetSlotTypesPaginator(LexModelBuildingClient client, GetSlotTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetSlotTypesResponseFetcher();
    }

    public Iterator<GetSlotTypesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class GetSlotTypesResponseFetcher
    implements NextPageFetcher<GetSlotTypesResponse> {
        private GetSlotTypesResponseFetcher() {
        }

        public boolean hasNextPage(GetSlotTypesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetSlotTypesResponse nextPage(GetSlotTypesResponse previousPage) {
            if (previousPage == null) {
                return GetSlotTypesPaginator.this.client.getSlotTypes(GetSlotTypesPaginator.this.firstRequest);
            }
            return GetSlotTypesPaginator.this.client.getSlotTypes((GetSlotTypesRequest)((Object)GetSlotTypesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

