/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.model.SynonymListCopier;
import software.amazon.awssdk.services.lexmodelbuilding.transform.EnumerationValueMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnumerationValue
implements StructuredPojo,
ToCopyableBuilder<Builder, EnumerationValue> {
    private final String value;
    private final List<String> synonyms;

    private EnumerationValue(BuilderImpl builder) {
        this.value = builder.value;
        this.synonyms = builder.synonyms;
    }

    public String value() {
        return this.value;
    }

    public List<String> synonyms() {
        return this.synonyms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.synonyms());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnumerationValue)) {
            return false;
        }
        EnumerationValue other = (EnumerationValue)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.synonyms(), other.synonyms());
    }

    public String toString() {
        return ToString.builder((String)"EnumerationValue").add("Value", (Object)this.value()).add("Synonyms", this.synonyms()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "value": {
                return Optional.of(clazz.cast(this.value()));
            }
            case "synonyms": {
                return Optional.of(clazz.cast(this.synonyms()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EnumerationValueMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String value;
        private List<String> synonyms;

        private BuilderImpl() {
        }

        private BuilderImpl(EnumerationValue model) {
            this.value(model.value);
            this.synonyms(model.synonyms);
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final Collection<String> getSynonyms() {
            return this.synonyms;
        }

        @Override
        public final Builder synonyms(Collection<String> synonyms) {
            this.synonyms = SynonymListCopier.copy(synonyms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder synonyms(String ... synonyms) {
            this.synonyms(Arrays.asList(synonyms));
            return this;
        }

        public final void setSynonyms(Collection<String> synonyms) {
            this.synonyms = SynonymListCopier.copy(synonyms);
        }

        public EnumerationValue build() {
            return new EnumerationValue(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnumerationValue> {
        public Builder value(String var1);

        public Builder synonyms(Collection<String> var1);

        public Builder synonyms(String ... var1);
    }
}

