/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ExportType {
    ALEXA_SKILLS_KIT("ALEXA_SKILLS_KIT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ExportType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExportType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ExportType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExportType> knownValues() {
        return Stream.of(ExportType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

