/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.lexmodelbuilding.model.BotMetadata;
import software.amazon.awssdk.services.lexmodelbuilding.model.BotMetadataListCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetBotVersionsResponse
extends LexModelBuildingResponse
implements ToCopyableBuilder<Builder, GetBotVersionsResponse> {
    private final List<BotMetadata> bots;
    private final String nextToken;

    private GetBotVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.bots = builder.bots;
        this.nextToken = builder.nextToken;
    }

    public List<BotMetadata> bots() {
        return this.bots;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bots());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBotVersionsResponse)) {
            return false;
        }
        GetBotVersionsResponse other = (GetBotVersionsResponse)((Object)obj);
        return Objects.equals(this.bots(), other.bots()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetBotVersionsResponse").add("Bots", this.bots()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bots": {
                return Optional.of(clazz.cast(this.bots()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LexModelBuildingResponse.BuilderImpl
    implements Builder {
        private List<BotMetadata> bots;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBotVersionsResponse model) {
            this.bots(model.bots);
            this.nextToken(model.nextToken);
        }

        public final Collection<BotMetadata.Builder> getBots() {
            return this.bots != null ? (Collection)this.bots.stream().map(BotMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder bots(Collection<BotMetadata> bots) {
            this.bots = BotMetadataListCopier.copy(bots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bots(BotMetadata ... bots) {
            this.bots(Arrays.asList(bots));
            return this;
        }

        public final void setBots(Collection<BotMetadata.BuilderImpl> bots) {
            this.bots = BotMetadataListCopier.copyFromBuilder(bots);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetBotVersionsResponse build() {
            return new GetBotVersionsResponse(this);
        }
    }

    public static interface Builder
    extends LexModelBuildingResponse.Builder,
    CopyableBuilder<Builder, GetBotVersionsResponse> {
        public Builder bots(Collection<BotMetadata> var1);

        public Builder bots(BotMetadata ... var1);

        public Builder nextToken(String var1);
    }
}

