/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotChannelAssociationsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotChannelAssociationsResponse;

public final class GetBotChannelAssociationsPaginator
implements SdkIterable<GetBotChannelAssociationsResponse> {
    private final LexModelBuildingClient client;
    private final GetBotChannelAssociationsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetBotChannelAssociationsPaginator(LexModelBuildingClient client, GetBotChannelAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetBotChannelAssociationsResponseFetcher();
    }

    public Iterator<GetBotChannelAssociationsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class GetBotChannelAssociationsResponseFetcher
    implements NextPageFetcher<GetBotChannelAssociationsResponse> {
        private GetBotChannelAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(GetBotChannelAssociationsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetBotChannelAssociationsResponse nextPage(GetBotChannelAssociationsResponse previousPage) {
            if (previousPage == null) {
                return GetBotChannelAssociationsPaginator.this.client.getBotChannelAssociations(GetBotChannelAssociationsPaginator.this.firstRequest);
            }
            return GetBotChannelAssociationsPaginator.this.client.getBotChannelAssociations((GetBotChannelAssociationsRequest)((Object)GetBotChannelAssociationsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

