/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentsResponse;

public final class GetIntentsPaginator
implements SdkIterable<GetIntentsResponse> {
    private final LexModelBuildingClient client;
    private final GetIntentsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetIntentsPaginator(LexModelBuildingClient client, GetIntentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetIntentsResponseFetcher();
    }

    public Iterator<GetIntentsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class GetIntentsResponseFetcher
    implements NextPageFetcher<GetIntentsResponse> {
        private GetIntentsResponseFetcher() {
        }

        public boolean hasNextPage(GetIntentsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetIntentsResponse nextPage(GetIntentsResponse previousPage) {
            if (previousPage == null) {
                return GetIntentsPaginator.this.client.getIntents(GetIntentsPaginator.this.firstRequest);
            }
            return GetIntentsPaginator.this.client.getIntents((GetIntentsRequest)((Object)GetIntentsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

