/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetBotVersionsResponse extends LexModelBuildingResponse implements
        ToCopyableBuilder<GetBotVersionsResponse.Builder, GetBotVersionsResponse> {
    private final List<BotMetadata> bots;

    private final String nextToken;

    private GetBotVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.bots = builder.bots;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An array of <code>BotMetadata</code> objects, one for each numbered version of the bot plus one for the
     * <code>$LATEST</code> version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>BotMetadata</code> objects, one for each numbered version of the bot plus one for the
     *         <code>$LATEST</code> version.
     */
    public List<BotMetadata> bots() {
        return bots;
    }

    /**
     * <p>
     * A pagination token for fetching the next page of bot versions. If the response to this call is truncated, Amazon
     * Lex returns a pagination token in the response. To fetch the next page of versions, specify the pagination token
     * in the next request.
     * </p>
     * 
     * @return A pagination token for fetching the next page of bot versions. If the response to this call is truncated,
     *         Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the
     *         pagination token in the next request.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bots());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBotVersionsResponse)) {
            return false;
        }
        GetBotVersionsResponse other = (GetBotVersionsResponse) obj;
        return Objects.equals(bots(), other.bots()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("GetBotVersionsResponse").add("Bots", bots()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bots":
            return Optional.of(clazz.cast(bots()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LexModelBuildingResponse.Builder, CopyableBuilder<Builder, GetBotVersionsResponse> {
        /**
         * <p>
         * An array of <code>BotMetadata</code> objects, one for each numbered version of the bot plus one for the
         * <code>$LATEST</code> version.
         * </p>
         * 
         * @param bots
         *        An array of <code>BotMetadata</code> objects, one for each numbered version of the bot plus one for
         *        the <code>$LATEST</code> version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bots(Collection<BotMetadata> bots);

        /**
         * <p>
         * An array of <code>BotMetadata</code> objects, one for each numbered version of the bot plus one for the
         * <code>$LATEST</code> version.
         * </p>
         * 
         * @param bots
         *        An array of <code>BotMetadata</code> objects, one for each numbered version of the bot plus one for
         *        the <code>$LATEST</code> version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bots(BotMetadata... bots);

        /**
         * <p>
         * A pagination token for fetching the next page of bot versions. If the response to this call is truncated,
         * Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the
         * pagination token in the next request.
         * </p>
         * 
         * @param nextToken
         *        A pagination token for fetching the next page of bot versions. If the response to this call is
         *        truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions,
         *        specify the pagination token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LexModelBuildingResponse.BuilderImpl implements Builder {
        private List<BotMetadata> bots;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBotVersionsResponse model) {
            bots(model.bots);
            nextToken(model.nextToken);
        }

        public final Collection<BotMetadata.Builder> getBots() {
            return bots != null ? bots.stream().map(BotMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder bots(Collection<BotMetadata> bots) {
            this.bots = BotMetadataListCopier.copy(bots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bots(BotMetadata... bots) {
            bots(Arrays.asList(bots));
            return this;
        }

        public final void setBots(Collection<BotMetadata.BuilderImpl> bots) {
            this.bots = BotMetadataListCopier.copyFromBuilder(bots);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetBotVersionsResponse build() {
            return new GetBotVersionsResponse(this);
        }
    }
}
