/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetBuiltinIntentResponse extends LexModelBuildingResponse implements
        ToCopyableBuilder<GetBuiltinIntentResponse.Builder, GetBuiltinIntentResponse> {
    private final String signature;

    private final List<String> supportedLocales;

    private final List<BuiltinIntentSlot> slots;

    private GetBuiltinIntentResponse(BuilderImpl builder) {
        super(builder);
        this.signature = builder.signature;
        this.supportedLocales = builder.supportedLocales;
        this.slots = builder.slots;
    }

    /**
     * <p>
     * The unique identifier for a built-in intent.
     * </p>
     * 
     * @return The unique identifier for a built-in intent.
     */
    public String signature() {
        return signature;
    }

    /**
     * <p>
     * A list of locales that the intent supports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of locales that the intent supports.
     */
    public List<Locale> supportedLocales() {
        return TypeConverter.convert(supportedLocales, Locale::fromValue);
    }

    /**
     * <p>
     * A list of locales that the intent supports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of locales that the intent supports.
     */
    public List<String> supportedLocalesStrings() {
        return supportedLocales;
    }

    /**
     * <p>
     * An array of <code>BuiltinIntentSlot</code> objects, one entry for each slot type in the intent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>BuiltinIntentSlot</code> objects, one entry for each slot type in the intent.
     */
    public List<BuiltinIntentSlot> slots() {
        return slots;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(signature());
        hashCode = 31 * hashCode + Objects.hashCode(supportedLocalesStrings());
        hashCode = 31 * hashCode + Objects.hashCode(slots());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBuiltinIntentResponse)) {
            return false;
        }
        GetBuiltinIntentResponse other = (GetBuiltinIntentResponse) obj;
        return Objects.equals(signature(), other.signature())
                && Objects.equals(supportedLocalesStrings(), other.supportedLocalesStrings())
                && Objects.equals(slots(), other.slots());
    }

    @Override
    public String toString() {
        return ToString.builder("GetBuiltinIntentResponse").add("Signature", signature())
                .add("SupportedLocales", supportedLocalesStrings()).add("Slots", slots()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "signature":
            return Optional.of(clazz.cast(signature()));
        case "supportedLocales":
            return Optional.of(clazz.cast(supportedLocalesStrings()));
        case "slots":
            return Optional.of(clazz.cast(slots()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LexModelBuildingResponse.Builder, CopyableBuilder<Builder, GetBuiltinIntentResponse> {
        /**
         * <p>
         * The unique identifier for a built-in intent.
         * </p>
         * 
         * @param signature
         *        The unique identifier for a built-in intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signature(String signature);

        /**
         * <p>
         * A list of locales that the intent supports.
         * </p>
         * 
         * @param supportedLocales
         *        A list of locales that the intent supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedLocales(Collection<String> supportedLocales);

        /**
         * <p>
         * A list of locales that the intent supports.
         * </p>
         * 
         * @param supportedLocales
         *        A list of locales that the intent supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedLocales(String... supportedLocales);

        /**
         * <p>
         * An array of <code>BuiltinIntentSlot</code> objects, one entry for each slot type in the intent.
         * </p>
         * 
         * @param slots
         *        An array of <code>BuiltinIntentSlot</code> objects, one entry for each slot type in the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slots(Collection<BuiltinIntentSlot> slots);

        /**
         * <p>
         * An array of <code>BuiltinIntentSlot</code> objects, one entry for each slot type in the intent.
         * </p>
         * 
         * @param slots
         *        An array of <code>BuiltinIntentSlot</code> objects, one entry for each slot type in the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slots(BuiltinIntentSlot... slots);
    }

    static final class BuilderImpl extends LexModelBuildingResponse.BuilderImpl implements Builder {
        private String signature;

        private List<String> supportedLocales;

        private List<BuiltinIntentSlot> slots;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBuiltinIntentResponse model) {
            signature(model.signature);
            supportedLocales(model.supportedLocales);
            slots(model.slots);
        }

        public final String getSignature() {
            return signature;
        }

        @Override
        public final Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public final void setSignature(String signature) {
            this.signature = signature;
        }

        public final Collection<String> getSupportedLocales() {
            return supportedLocales;
        }

        @Override
        public final Builder supportedLocales(Collection<String> supportedLocales) {
            this.supportedLocales = LocaleListCopier.copy(supportedLocales);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedLocales(String... supportedLocales) {
            supportedLocales(Arrays.asList(supportedLocales));
            return this;
        }

        public final void setSupportedLocales(Collection<String> supportedLocales) {
            this.supportedLocales = LocaleListCopier.copy(supportedLocales);
        }

        public final Collection<BuiltinIntentSlot.Builder> getSlots() {
            return slots != null ? slots.stream().map(BuiltinIntentSlot::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder slots(Collection<BuiltinIntentSlot> slots) {
            this.slots = BuiltinIntentSlotListCopier.copy(slots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slots(BuiltinIntentSlot... slots) {
            slots(Arrays.asList(slots));
            return this;
        }

        public final void setSlots(Collection<BuiltinIntentSlot.BuilderImpl> slots) {
            this.slots = BuiltinIntentSlotListCopier.copyFromBuilder(slots);
        }

        @Override
        public GetBuiltinIntentResponse build() {
            return new GetBuiltinIntentResponse(this);
        }
    }
}
