/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetBuiltinIntentsRequest extends LexModelBuildingRequest implements
        ToCopyableBuilder<GetBuiltinIntentsRequest.Builder, GetBuiltinIntentsRequest> {
    private final String locale;

    private final String signatureContains;

    private final String nextToken;

    private final Integer maxResults;

    private GetBuiltinIntentsRequest(BuilderImpl builder) {
        super(builder);
        this.locale = builder.locale;
        this.signatureContains = builder.signatureContains;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * A list of locales that the intent supports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locale} will
     * return {@link Locale#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #localeString}.
     * </p>
     * 
     * @return A list of locales that the intent supports.
     * @see Locale
     */
    public Locale locale() {
        return Locale.fromValue(locale);
    }

    /**
     * <p>
     * A list of locales that the intent supports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locale} will
     * return {@link Locale#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #localeString}.
     * </p>
     * 
     * @return A list of locales that the intent supports.
     * @see Locale
     */
    public String localeString() {
        return locale;
    }

    /**
     * <p>
     * Substring to match in built-in intent signatures. An intent will be returned if any part of its signature matches
     * the substring. For example, "xyz" matches both "xyzabc" and "abcxyz." To find the signature for an intent, see <a
     * href=
     * "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents"
     * >Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.
     * </p>
     * 
     * @return Substring to match in built-in intent signatures. An intent will be returned if any part of its signature
     *         matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz." To find the signature for
     *         an intent, see <a href=
     *         "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents"
     *         >Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.
     */
    public String signatureContains() {
        return signatureContains;
    }

    /**
     * <p>
     * A pagination token that fetches the next page of intents. If this API call is truncated, Amazon Lex returns a
     * pagination token in the response. To fetch the next page of intents, use the pagination token in the next
     * request.
     * </p>
     * 
     * @return A pagination token that fetches the next page of intents. If this API call is truncated, Amazon Lex
     *         returns a pagination token in the response. To fetch the next page of intents, use the pagination token
     *         in the next request.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of intents to return in the response. The default is 10.
     * </p>
     * 
     * @return The maximum number of intents to return in the response. The default is 10.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(localeString());
        hashCode = 31 * hashCode + Objects.hashCode(signatureContains());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBuiltinIntentsRequest)) {
            return false;
        }
        GetBuiltinIntentsRequest other = (GetBuiltinIntentsRequest) obj;
        return Objects.equals(localeString(), other.localeString())
                && Objects.equals(signatureContains(), other.signatureContains())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    @Override
    public String toString() {
        return ToString.builder("GetBuiltinIntentsRequest").add("Locale", localeString())
                .add("SignatureContains", signatureContains()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "locale":
            return Optional.of(clazz.cast(localeString()));
        case "signatureContains":
            return Optional.of(clazz.cast(signatureContains()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.of(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LexModelBuildingRequest.Builder, CopyableBuilder<Builder, GetBuiltinIntentsRequest> {
        /**
         * <p>
         * A list of locales that the intent supports.
         * </p>
         * 
         * @param locale
         *        A list of locales that the intent supports.
         * @see Locale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder locale(String locale);

        /**
         * <p>
         * A list of locales that the intent supports.
         * </p>
         * 
         * @param locale
         *        A list of locales that the intent supports.
         * @see Locale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder locale(Locale locale);

        /**
         * <p>
         * Substring to match in built-in intent signatures. An intent will be returned if any part of its signature
         * matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz." To find the signature for an
         * intent, see <a href=
         * "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents"
         * >Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.
         * </p>
         * 
         * @param signatureContains
         *        Substring to match in built-in intent signatures. An intent will be returned if any part of its
         *        signature matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz." To find the
         *        signature for an intent, see <a href=
         *        "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents"
         *        >Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signatureContains(String signatureContains);

        /**
         * <p>
         * A pagination token that fetches the next page of intents. If this API call is truncated, Amazon Lex returns a
         * pagination token in the response. To fetch the next page of intents, use the pagination token in the next
         * request.
         * </p>
         * 
         * @param nextToken
         *        A pagination token that fetches the next page of intents. If this API call is truncated, Amazon Lex
         *        returns a pagination token in the response. To fetch the next page of intents, use the pagination
         *        token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of intents to return in the response. The default is 10.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of intents to return in the response. The default is 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends LexModelBuildingRequest.BuilderImpl implements Builder {
        private String locale;

        private String signatureContains;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBuiltinIntentsRequest model) {
            locale(model.locale);
            signatureContains(model.signatureContains);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getLocale() {
            return locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(Locale locale) {
            this.locale(locale.toString());
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        public final String getSignatureContains() {
            return signatureContains;
        }

        @Override
        public final Builder signatureContains(String signatureContains) {
            this.signatureContains = signatureContains;
            return this;
        }

        public final void setSignatureContains(String signatureContains) {
            this.signatureContains = signatureContains;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetBuiltinIntentsRequest build() {
            return new GetBuiltinIntentsRequest(this);
        }
    }
}
