/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetExportRequest extends LexModelBuildingRequest implements
        ToCopyableBuilder<GetExportRequest.Builder, GetExportRequest> {
    private final String name;

    private final String version;

    private final String resourceType;

    private final String exportType;

    private GetExportRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.version = builder.version;
        this.resourceType = builder.resourceType;
        this.exportType = builder.exportType;
    }

    /**
     * <p>
     * The name of the bot to export.
     * </p>
     * 
     * @return The name of the bot to export.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The version of the bot to export.
     * </p>
     * 
     * @return The version of the bot to export.
     */
    public String version() {
        return version;
    }

    /**
     * <p>
     * The type of resource to export.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeString}.
     * </p>
     * 
     * @return The type of resource to export.
     * @see ResourceType
     */
    public ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of resource to export.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeString}.
     * </p>
     * 
     * @return The type of resource to export.
     * @see ResourceType
     */
    public String resourceTypeString() {
        return resourceType;
    }

    /**
     * <p>
     * The format of the exported data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportType} will
     * return {@link ExportType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportTypeString}.
     * </p>
     * 
     * @return The format of the exported data.
     * @see ExportType
     */
    public ExportType exportType() {
        return ExportType.fromValue(exportType);
    }

    /**
     * <p>
     * The format of the exported data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportType} will
     * return {@link ExportType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportTypeString}.
     * </p>
     * 
     * @return The format of the exported data.
     * @see ExportType
     */
    public String exportTypeString() {
        return exportType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(exportTypeString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExportRequest)) {
            return false;
        }
        GetExportRequest other = (GetExportRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(version(), other.version())
                && Objects.equals(resourceTypeString(), other.resourceTypeString())
                && Objects.equals(exportTypeString(), other.exportTypeString());
    }

    @Override
    public String toString() {
        return ToString.builder("GetExportRequest").add("Name", name()).add("Version", version())
                .add("ResourceType", resourceTypeString()).add("ExportType", exportTypeString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.of(clazz.cast(name()));
        case "version":
            return Optional.of(clazz.cast(version()));
        case "resourceType":
            return Optional.of(clazz.cast(resourceTypeString()));
        case "exportType":
            return Optional.of(clazz.cast(exportTypeString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LexModelBuildingRequest.Builder, CopyableBuilder<Builder, GetExportRequest> {
        /**
         * <p>
         * The name of the bot to export.
         * </p>
         * 
         * @param name
         *        The name of the bot to export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The version of the bot to export.
         * </p>
         * 
         * @param version
         *        The version of the bot to export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The type of resource to export.
         * </p>
         * 
         * @param resourceType
         *        The type of resource to export.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resource to export.
         * </p>
         * 
         * @param resourceType
         *        The type of resource to export.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The format of the exported data.
         * </p>
         * 
         * @param exportType
         *        The format of the exported data.
         * @see ExportType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportType
         */
        Builder exportType(String exportType);

        /**
         * <p>
         * The format of the exported data.
         * </p>
         * 
         * @param exportType
         *        The format of the exported data.
         * @see ExportType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportType
         */
        Builder exportType(ExportType exportType);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends LexModelBuildingRequest.BuilderImpl implements Builder {
        private String name;

        private String version;

        private String resourceType;

        private String exportType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExportRequest model) {
            name(model.name);
            version(model.version);
            resourceType(model.resourceType);
            exportType(model.exportType);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getExportType() {
            return exportType;
        }

        @Override
        public final Builder exportType(String exportType) {
            this.exportType = exportType;
            return this;
        }

        @Override
        public final Builder exportType(ExportType exportType) {
            this.exportType(exportType.toString());
            return this;
        }

        public final void setExportType(String exportType) {
            this.exportType = exportType;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetExportRequest build() {
            return new GetExportRequest(this);
        }
    }
}
