/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetIntentVersionsResponse extends LexModelBuildingResponse implements
        ToCopyableBuilder<GetIntentVersionsResponse.Builder, GetIntentVersionsResponse> {
    private final List<IntentMetadata> intents;

    private final String nextToken;

    private GetIntentVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.intents = builder.intents;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An array of <code>IntentMetadata</code> objects, one for each numbered version of the intent plus one for the
     * <code>$LATEST</code> version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>IntentMetadata</code> objects, one for each numbered version of the intent plus one for
     *         the <code>$LATEST</code> version.
     */
    public List<IntentMetadata> intents() {
        return intents;
    }

    /**
     * <p>
     * A pagination token for fetching the next page of intent versions. If the response to this call is truncated,
     * Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the pagination
     * token in the next request.
     * </p>
     * 
     * @return A pagination token for fetching the next page of intent versions. If the response to this call is
     *         truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions,
     *         specify the pagination token in the next request.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(intents());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIntentVersionsResponse)) {
            return false;
        }
        GetIntentVersionsResponse other = (GetIntentVersionsResponse) obj;
        return Objects.equals(intents(), other.intents()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("GetIntentVersionsResponse").add("Intents", intents()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "intents":
            return Optional.of(clazz.cast(intents()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LexModelBuildingResponse.Builder, CopyableBuilder<Builder, GetIntentVersionsResponse> {
        /**
         * <p>
         * An array of <code>IntentMetadata</code> objects, one for each numbered version of the intent plus one for the
         * <code>$LATEST</code> version.
         * </p>
         * 
         * @param intents
         *        An array of <code>IntentMetadata</code> objects, one for each numbered version of the intent plus one
         *        for the <code>$LATEST</code> version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intents(Collection<IntentMetadata> intents);

        /**
         * <p>
         * An array of <code>IntentMetadata</code> objects, one for each numbered version of the intent plus one for the
         * <code>$LATEST</code> version.
         * </p>
         * 
         * @param intents
         *        An array of <code>IntentMetadata</code> objects, one for each numbered version of the intent plus one
         *        for the <code>$LATEST</code> version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intents(IntentMetadata... intents);

        /**
         * <p>
         * A pagination token for fetching the next page of intent versions. If the response to this call is truncated,
         * Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the
         * pagination token in the next request.
         * </p>
         * 
         * @param nextToken
         *        A pagination token for fetching the next page of intent versions. If the response to this call is
         *        truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions,
         *        specify the pagination token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LexModelBuildingResponse.BuilderImpl implements Builder {
        private List<IntentMetadata> intents;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIntentVersionsResponse model) {
            intents(model.intents);
            nextToken(model.nextToken);
        }

        public final Collection<IntentMetadata.Builder> getIntents() {
            return intents != null ? intents.stream().map(IntentMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder intents(Collection<IntentMetadata> intents) {
            this.intents = IntentMetadataListCopier.copy(intents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intents(IntentMetadata... intents) {
            intents(Arrays.asList(intents));
            return this;
        }

        public final void setIntents(Collection<IntentMetadata.BuilderImpl> intents) {
            this.intents = IntentMetadataListCopier.copyFromBuilder(intents);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetIntentVersionsResponse build() {
            return new GetIntentVersionsResponse(this);
        }
    }
}
