/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.transform;

import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.model.PutBotRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link PutBotRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class PutBotRequestModelMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PATH).marshallLocationName("name").isBinary(false).build();

    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();

    private static final MarshallingInfo<List> INTENTS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("intents").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> CLARIFICATIONPROMPT_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("clarificationPrompt").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> ABORTSTATEMENT_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("abortStatement").isBinary(false).build();

    private static final MarshallingInfo<Integer> IDLESESSIONTTLINSECONDS_BINDING = MarshallingInfo
            .builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("idleSessionTTLInSeconds").isBinary(false).build();

    private static final MarshallingInfo<String> VOICEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("voiceId").isBinary(false).build();

    private static final MarshallingInfo<String> CHECKSUM_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("checksum").isBinary(false).build();

    private static final MarshallingInfo<String> PROCESSBEHAVIOR_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("processBehavior").isBinary(false).build();

    private static final MarshallingInfo<String> LOCALE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("locale").isBinary(false).build();

    private static final MarshallingInfo<Boolean> CHILDDIRECTED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("childDirected").isBinary(false).build();

    private static final PutBotRequestModelMarshaller INSTANCE = new PutBotRequestModelMarshaller();

    private PutBotRequestModelMarshaller() {
    }

    public static PutBotRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(PutBotRequest putBotRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(putBotRequest, "putBotRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(putBotRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall(putBotRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(putBotRequest.intents(), INTENTS_BINDING);
            protocolMarshaller.marshall(putBotRequest.clarificationPrompt(), CLARIFICATIONPROMPT_BINDING);
            protocolMarshaller.marshall(putBotRequest.abortStatement(), ABORTSTATEMENT_BINDING);
            protocolMarshaller.marshall(putBotRequest.idleSessionTTLInSeconds(), IDLESESSIONTTLINSECONDS_BINDING);
            protocolMarshaller.marshall(putBotRequest.voiceId(), VOICEID_BINDING);
            protocolMarshaller.marshall(putBotRequest.checksum(), CHECKSUM_BINDING);
            protocolMarshaller.marshall(putBotRequest.processBehaviorString(), PROCESSBEHAVIOR_BINDING);
            protocolMarshaller.marshall(putBotRequest.localeString(), LOCALE_BINDING);
            protocolMarshaller.marshall(putBotRequest.childDirected(), CHILDDIRECTED_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
