/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.model.Prompt;
import software.amazon.awssdk.services.lexmodelbuilding.model.Statement;
import software.amazon.awssdk.services.lexmodelbuilding.transform.FollowUpPromptMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FollowUpPrompt
implements StructuredPojo,
ToCopyableBuilder<Builder, FollowUpPrompt> {
    private final Prompt prompt;
    private final Statement rejectionStatement;

    private FollowUpPrompt(BuilderImpl builder) {
        this.prompt = builder.prompt;
        this.rejectionStatement = builder.rejectionStatement;
    }

    public Prompt prompt() {
        return this.prompt;
    }

    public Statement rejectionStatement() {
        return this.rejectionStatement;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.prompt());
        hashCode = 31 * hashCode + Objects.hashCode(this.rejectionStatement());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FollowUpPrompt)) {
            return false;
        }
        FollowUpPrompt other = (FollowUpPrompt)obj;
        return Objects.equals(this.prompt(), other.prompt()) && Objects.equals(this.rejectionStatement(), other.rejectionStatement());
    }

    public String toString() {
        return ToString.builder((String)"FollowUpPrompt").add("Prompt", (Object)this.prompt()).add("RejectionStatement", (Object)this.rejectionStatement()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "prompt": {
                return Optional.of(clazz.cast(this.prompt()));
            }
            case "rejectionStatement": {
                return Optional.of(clazz.cast(this.rejectionStatement()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FollowUpPromptMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Prompt prompt;
        private Statement rejectionStatement;

        private BuilderImpl() {
        }

        private BuilderImpl(FollowUpPrompt model) {
            this.prompt(model.prompt);
            this.rejectionStatement(model.rejectionStatement);
        }

        public final Prompt.Builder getPrompt() {
            return this.prompt != null ? this.prompt.toBuilder() : null;
        }

        @Override
        public final Builder prompt(Prompt prompt) {
            this.prompt = prompt;
            return this;
        }

        public final void setPrompt(Prompt.BuilderImpl prompt) {
            this.prompt = prompt != null ? prompt.build() : null;
        }

        public final Statement.Builder getRejectionStatement() {
            return this.rejectionStatement != null ? this.rejectionStatement.toBuilder() : null;
        }

        @Override
        public final Builder rejectionStatement(Statement rejectionStatement) {
            this.rejectionStatement = rejectionStatement;
            return this;
        }

        public final void setRejectionStatement(Statement.BuilderImpl rejectionStatement) {
            this.rejectionStatement = rejectionStatement != null ? rejectionStatement.build() : null;
        }

        public FollowUpPrompt build() {
            return new FollowUpPrompt(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FollowUpPrompt> {
        public Builder prompt(Prompt var1);

        default public Builder prompt(Consumer<Prompt.Builder> prompt) {
            return this.prompt((Prompt)((Prompt.Builder)Prompt.builder().apply(prompt)).build());
        }

        public Builder rejectionStatement(Statement var1);

        default public Builder rejectionStatement(Consumer<Statement.Builder> rejectionStatement) {
            return this.rejectionStatement((Statement)((Statement.Builder)Statement.builder().apply(rejectionStatement)).build());
        }
    }
}

