/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.transform.IntentMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Intent
implements StructuredPojo,
ToCopyableBuilder<Builder, Intent> {
    private final String intentName;
    private final String intentVersion;

    private Intent(BuilderImpl builder) {
        this.intentName = builder.intentName;
        this.intentVersion = builder.intentVersion;
    }

    public String intentName() {
        return this.intentName;
    }

    public String intentVersion() {
        return this.intentVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.intentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.intentVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Intent)) {
            return false;
        }
        Intent other = (Intent)obj;
        return Objects.equals(this.intentName(), other.intentName()) && Objects.equals(this.intentVersion(), other.intentVersion());
    }

    public String toString() {
        return ToString.builder((String)"Intent").add("IntentName", (Object)this.intentName()).add("IntentVersion", (Object)this.intentVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "intentName": {
                return Optional.of(clazz.cast(this.intentName()));
            }
            case "intentVersion": {
                return Optional.of(clazz.cast(this.intentVersion()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IntentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String intentName;
        private String intentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(Intent model) {
            this.intentName(model.intentName);
            this.intentVersion(model.intentVersion);
        }

        public final String getIntentName() {
            return this.intentName;
        }

        @Override
        public final Builder intentName(String intentName) {
            this.intentName = intentName;
            return this;
        }

        public final void setIntentName(String intentName) {
            this.intentName = intentName;
        }

        public final String getIntentVersion() {
            return this.intentVersion;
        }

        @Override
        public final Builder intentVersion(String intentVersion) {
            this.intentVersion = intentVersion;
            return this;
        }

        public final void setIntentVersion(String intentVersion) {
            this.intentVersion = intentVersion;
        }

        public Intent build() {
            return new Intent(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Intent> {
        public Builder intentName(String var1);

        public Builder intentVersion(String var1);
    }
}

