/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotsResponse;

public class GetBotsIterable
implements SdkIterable<GetBotsResponse> {
    private final LexModelBuildingClient client;
    private final GetBotsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetBotsIterable(LexModelBuildingClient client, GetBotsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetBotsResponseFetcher();
    }

    public Iterator<GetBotsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final GetBotsIterable resume(GetBotsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetBotsIterable(this.client, (GetBotsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetBotsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetBotsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetBotsResponseFetcher
    implements SyncPageFetcher<GetBotsResponse> {
        private GetBotsResponseFetcher() {
        }

        public boolean hasNextPage(GetBotsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetBotsResponse nextPage(GetBotsResponse previousPage) {
            if (previousPage == null) {
                return GetBotsIterable.this.client.getBots(GetBotsIterable.this.firstRequest);
            }
            return GetBotsIterable.this.client.getBots((GetBotsRequest)((Object)GetBotsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

