/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinIntentsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinIntentsResponse;

public class GetBuiltinIntentsIterable
implements SdkIterable<GetBuiltinIntentsResponse> {
    private final LexModelBuildingClient client;
    private final GetBuiltinIntentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetBuiltinIntentsIterable(LexModelBuildingClient client, GetBuiltinIntentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetBuiltinIntentsResponseFetcher();
    }

    public Iterator<GetBuiltinIntentsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final GetBuiltinIntentsIterable resume(GetBuiltinIntentsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetBuiltinIntentsIterable(this.client, (GetBuiltinIntentsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetBuiltinIntentsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetBuiltinIntentsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetBuiltinIntentsResponseFetcher
    implements SyncPageFetcher<GetBuiltinIntentsResponse> {
        private GetBuiltinIntentsResponseFetcher() {
        }

        public boolean hasNextPage(GetBuiltinIntentsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetBuiltinIntentsResponse nextPage(GetBuiltinIntentsResponse previousPage) {
            if (previousPage == null) {
                return GetBuiltinIntentsIterable.this.client.getBuiltinIntents(GetBuiltinIntentsIterable.this.firstRequest);
            }
            return GetBuiltinIntentsIterable.this.client.getBuiltinIntents((GetBuiltinIntentsRequest)((Object)GetBuiltinIntentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

