/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinSlotTypesResponse;

public class GetBuiltinSlotTypesIterable
implements SdkIterable<GetBuiltinSlotTypesResponse> {
    private final LexModelBuildingClient client;
    private final GetBuiltinSlotTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetBuiltinSlotTypesIterable(LexModelBuildingClient client, GetBuiltinSlotTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetBuiltinSlotTypesResponseFetcher();
    }

    public Iterator<GetBuiltinSlotTypesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final GetBuiltinSlotTypesIterable resume(GetBuiltinSlotTypesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetBuiltinSlotTypesIterable(this.client, (GetBuiltinSlotTypesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetBuiltinSlotTypesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetBuiltinSlotTypesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetBuiltinSlotTypesResponseFetcher
    implements SyncPageFetcher<GetBuiltinSlotTypesResponse> {
        private GetBuiltinSlotTypesResponseFetcher() {
        }

        public boolean hasNextPage(GetBuiltinSlotTypesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetBuiltinSlotTypesResponse nextPage(GetBuiltinSlotTypesResponse previousPage) {
            if (previousPage == null) {
                return GetBuiltinSlotTypesIterable.this.client.getBuiltinSlotTypes(GetBuiltinSlotTypesIterable.this.firstRequest);
            }
            return GetBuiltinSlotTypesIterable.this.client.getBuiltinSlotTypes((GetBuiltinSlotTypesRequest)((Object)GetBuiltinSlotTypesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

