/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypeVersionsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypeVersionsResponse;

public class GetSlotTypeVersionsIterable
implements SdkIterable<GetSlotTypeVersionsResponse> {
    private final LexModelBuildingClient client;
    private final GetSlotTypeVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetSlotTypeVersionsIterable(LexModelBuildingClient client, GetSlotTypeVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetSlotTypeVersionsResponseFetcher();
    }

    public Iterator<GetSlotTypeVersionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final GetSlotTypeVersionsIterable resume(GetSlotTypeVersionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetSlotTypeVersionsIterable(this.client, (GetSlotTypeVersionsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetSlotTypeVersionsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetSlotTypeVersionsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetSlotTypeVersionsResponseFetcher
    implements SyncPageFetcher<GetSlotTypeVersionsResponse> {
        private GetSlotTypeVersionsResponseFetcher() {
        }

        public boolean hasNextPage(GetSlotTypeVersionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetSlotTypeVersionsResponse nextPage(GetSlotTypeVersionsResponse previousPage) {
            if (previousPage == null) {
                return GetSlotTypeVersionsIterable.this.client.getSlotTypeVersions(GetSlotTypeVersionsIterable.this.firstRequest);
            }
            return GetSlotTypeVersionsIterable.this.client.getSlotTypeVersions((GetSlotTypeVersionsRequest)((Object)GetSlotTypeVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

