/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingAsyncClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypeVersionsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypeVersionsResponse;

public class GetSlotTypeVersionsPublisher
implements SdkPublisher<GetSlotTypeVersionsResponse> {
    private final LexModelBuildingAsyncClient client;
    private final GetSlotTypeVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetSlotTypeVersionsPublisher(LexModelBuildingAsyncClient client, GetSlotTypeVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetSlotTypeVersionsPublisher(LexModelBuildingAsyncClient client, GetSlotTypeVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetSlotTypeVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetSlotTypeVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final GetSlotTypeVersionsPublisher resume(GetSlotTypeVersionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetSlotTypeVersionsPublisher(this.client, (GetSlotTypeVersionsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetSlotTypeVersionsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetSlotTypeVersionsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetSlotTypeVersionsResponseFetcher
    implements AsyncPageFetcher<GetSlotTypeVersionsResponse> {
        private GetSlotTypeVersionsResponseFetcher() {
        }

        public boolean hasNextPage(GetSlotTypeVersionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<GetSlotTypeVersionsResponse> nextPage(GetSlotTypeVersionsResponse previousPage) {
            if (previousPage == null) {
                return GetSlotTypeVersionsPublisher.this.client.getSlotTypeVersions(GetSlotTypeVersionsPublisher.this.firstRequest);
            }
            return GetSlotTypeVersionsPublisher.this.client.getSlotTypeVersions((GetSlotTypeVersionsRequest)((Object)GetSlotTypeVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

