/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.model.EnumerationValue;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EnumerationValueMarshaller {
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("value").isBinary(false).build();
    private static final MarshallingInfo<List> SYNONYMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("synonyms").isBinary(false).build();
    private static final EnumerationValueMarshaller INSTANCE = new EnumerationValueMarshaller();

    private EnumerationValueMarshaller() {
    }

    public static EnumerationValueMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EnumerationValue enumerationValue, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)enumerationValue, (String)"enumerationValue");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)enumerationValue.value(), VALUE_BINDING);
            protocolMarshaller.marshall(enumerationValue.synonyms(), SYNONYMS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

