/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.model.UtteranceData;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UtteranceDataMarshaller {
    private static final MarshallingInfo<String> UTTERANCESTRING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("utteranceString").isBinary(false).build();
    private static final MarshallingInfo<Integer> COUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("count").isBinary(false).build();
    private static final MarshallingInfo<Integer> DISTINCTUSERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("distinctUsers").isBinary(false).build();
    private static final MarshallingInfo<Instant> FIRSTUTTEREDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("firstUtteredDate").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTUTTEREDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUtteredDate").isBinary(false).build();
    private static final UtteranceDataMarshaller INSTANCE = new UtteranceDataMarshaller();

    private UtteranceDataMarshaller() {
    }

    public static UtteranceDataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UtteranceData utteranceData, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)utteranceData, (String)"utteranceData");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)utteranceData.utteranceString(), UTTERANCESTRING_BINDING);
            protocolMarshaller.marshall((Object)utteranceData.count(), COUNT_BINDING);
            protocolMarshaller.marshall((Object)utteranceData.distinctUsers(), DISTINCTUSERS_BINDING);
            protocolMarshaller.marshall((Object)utteranceData.firstUtteredDate(), FIRSTUTTEREDDATE_BINDING);
            protocolMarshaller.marshall((Object)utteranceData.lastUtteredDate(), LASTUTTEREDDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

