/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutSlotTypeRequest extends LexModelBuildingRequest implements
        ToCopyableBuilder<PutSlotTypeRequest.Builder, PutSlotTypeRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutSlotTypeRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutSlotTypeRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<EnumerationValue>> ENUMERATION_VALUES_FIELD = SdkField
            .<List<EnumerationValue>> builder(MarshallingType.LIST)
            .getter(getter(PutSlotTypeRequest::enumerationValues))
            .setter(setter(Builder::enumerationValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enumerationValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnumerationValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnumerationValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CHECKSUM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutSlotTypeRequest::checksum)).setter(setter(Builder::checksum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checksum").build()).build();

    private static final SdkField<String> VALUE_SELECTION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutSlotTypeRequest::valueSelectionStrategyAsString)).setter(setter(Builder::valueSelectionStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueSelectionStrategy").build())
            .build();

    private static final SdkField<Boolean> CREATE_VERSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(PutSlotTypeRequest::createVersion)).setter(setter(Builder::createVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            ENUMERATION_VALUES_FIELD, CHECKSUM_FIELD, VALUE_SELECTION_STRATEGY_FIELD, CREATE_VERSION_FIELD));

    private final String name;

    private final String description;

    private final List<EnumerationValue> enumerationValues;

    private final String checksum;

    private final String valueSelectionStrategy;

    private final Boolean createVersion;

    private PutSlotTypeRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.enumerationValues = builder.enumerationValues;
        this.checksum = builder.checksum;
        this.valueSelectionStrategy = builder.valueSelectionStrategy;
        this.createVersion = builder.createVersion;
    }

    /**
     * <p>
     * The name of the slot type. The name is <i>not</i> case sensitive.
     * </p>
     * <p>
     * The name can't match a built-in slot type name, or a built-in slot type name with "AMAZON." removed. For example,
     * because there is a built-in slot type called <code>AMAZON.DATE</code>, you can't create a custom slot type called
     * <code>DATE</code>.
     * </p>
     * <p>
     * For a list of built-in slot types, see <a href=
     * "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference"
     * >Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.
     * </p>
     * 
     * @return The name of the slot type. The name is <i>not</i> case sensitive. </p>
     *         <p>
     *         The name can't match a built-in slot type name, or a built-in slot type name with "AMAZON." removed. For
     *         example, because there is a built-in slot type called <code>AMAZON.DATE</code>, you can't create a custom
     *         slot type called <code>DATE</code>.
     *         </p>
     *         <p>
     *         For a list of built-in slot types, see <a href=
     *         "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference"
     *         >Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A description of the slot type.
     * </p>
     * 
     * @return A description of the slot type.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take. Each value
     * can have a list of <code>synonyms</code>, which are additional values that help train the machine learning model
     * about the values that it resolves for a slot.
     * </p>
     * <p>
     * When Amazon Lex resolves a slot value, it generates a resolution list that contains up to five possible values
     * for the slot. If you are using a Lambda function, this resolution list is passed to the function. If you are not
     * using a Lambda function you can choose to return the value that the user entered or the first value in the
     * resolution list as the slot value. The <code>valueSelectionStrategy</code> field indicates the option to use.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take. Each
     *         value can have a list of <code>synonyms</code>, which are additional values that help train the machine
     *         learning model about the values that it resolves for a slot. </p>
     *         <p>
     *         When Amazon Lex resolves a slot value, it generates a resolution list that contains up to five possible
     *         values for the slot. If you are using a Lambda function, this resolution list is passed to the function.
     *         If you are not using a Lambda function you can choose to return the value that the user entered or the
     *         first value in the resolution list as the slot value. The <code>valueSelectionStrategy</code> field
     *         indicates the option to use.
     */
    public List<EnumerationValue> enumerationValues() {
        return enumerationValues;
    }

    /**
     * <p>
     * Identifies a specific revision of the <code>$LATEST</code> version.
     * </p>
     * <p>
     * When you create a new slot type, leave the <code>checksum</code> field blank. If you specify a checksum you get a
     * <code>BadRequestException</code> exception.
     * </p>
     * <p>
     * When you want to update a slot type, set the <code>checksum</code> field to the checksum of the most recent
     * revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code> field, or if the
     * checksum does not match the <code>$LATEST</code> version, you get a <code>PreconditionFailedException</code>
     * exception.
     * </p>
     * 
     * @return Identifies a specific revision of the <code>$LATEST</code> version.</p>
     *         <p>
     *         When you create a new slot type, leave the <code>checksum</code> field blank. If you specify a checksum
     *         you get a <code>BadRequestException</code> exception.
     *         </p>
     *         <p>
     *         When you want to update a slot type, set the <code>checksum</code> field to the checksum of the most
     *         recent revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code>
     *         field, or if the checksum does not match the <code>$LATEST</code> version, you get a
     *         <code>PreconditionFailedException</code> exception.
     */
    public String checksum() {
        return checksum;
    }

    /**
     * <p>
     * Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can be set to
     * one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to the slot
     * value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in the
     * resolution list as the slot type value. If there is no resolution list, null is returned.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you don't specify the <code>valueSelectionStrategy</code>, the default is <code>ORIGINAL_VALUE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #valueSelectionStrategy} will return {@link SlotValueSelectionStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #valueSelectionStrategyAsString}.
     * </p>
     * 
     * @return Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can be
     *         set to one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to the
     *         slot value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in the
     *         resolution list as the slot type value. If there is no resolution list, null is returned.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you don't specify the <code>valueSelectionStrategy</code>, the default is <code>ORIGINAL_VALUE</code>.
     * @see SlotValueSelectionStrategy
     */
    public SlotValueSelectionStrategy valueSelectionStrategy() {
        return SlotValueSelectionStrategy.fromValue(valueSelectionStrategy);
    }

    /**
     * <p>
     * Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can be set to
     * one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to the slot
     * value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in the
     * resolution list as the slot type value. If there is no resolution list, null is returned.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you don't specify the <code>valueSelectionStrategy</code>, the default is <code>ORIGINAL_VALUE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #valueSelectionStrategy} will return {@link SlotValueSelectionStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #valueSelectionStrategyAsString}.
     * </p>
     * 
     * @return Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can be
     *         set to one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to the
     *         slot value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in the
     *         resolution list as the slot type value. If there is no resolution list, null is returned.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you don't specify the <code>valueSelectionStrategy</code>, the default is <code>ORIGINAL_VALUE</code>.
     * @see SlotValueSelectionStrategy
     */
    public String valueSelectionStrategyAsString() {
        return valueSelectionStrategy;
    }

    /**
     * Returns the value of the CreateVersion property for this object.
     * 
     * @return The value of the CreateVersion property for this object.
     */
    public Boolean createVersion() {
        return createVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(enumerationValues());
        hashCode = 31 * hashCode + Objects.hashCode(checksum());
        hashCode = 31 * hashCode + Objects.hashCode(valueSelectionStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSlotTypeRequest)) {
            return false;
        }
        PutSlotTypeRequest other = (PutSlotTypeRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(enumerationValues(), other.enumerationValues()) && Objects.equals(checksum(), other.checksum())
                && Objects.equals(valueSelectionStrategyAsString(), other.valueSelectionStrategyAsString())
                && Objects.equals(createVersion(), other.createVersion());
    }

    @Override
    public String toString() {
        return ToString.builder("PutSlotTypeRequest").add("Name", name()).add("Description", description())
                .add("EnumerationValues", enumerationValues()).add("Checksum", checksum())
                .add("ValueSelectionStrategy", valueSelectionStrategyAsString()).add("CreateVersion", createVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "enumerationValues":
            return Optional.ofNullable(clazz.cast(enumerationValues()));
        case "checksum":
            return Optional.ofNullable(clazz.cast(checksum()));
        case "valueSelectionStrategy":
            return Optional.ofNullable(clazz.cast(valueSelectionStrategyAsString()));
        case "createVersion":
            return Optional.ofNullable(clazz.cast(createVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutSlotTypeRequest, T> g) {
        return obj -> g.apply((PutSlotTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelBuildingRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutSlotTypeRequest> {
        /**
         * <p>
         * The name of the slot type. The name is <i>not</i> case sensitive.
         * </p>
         * <p>
         * The name can't match a built-in slot type name, or a built-in slot type name with "AMAZON." removed. For
         * example, because there is a built-in slot type called <code>AMAZON.DATE</code>, you can't create a custom
         * slot type called <code>DATE</code>.
         * </p>
         * <p>
         * For a list of built-in slot types, see <a href=
         * "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference"
         * >Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.
         * </p>
         * 
         * @param name
         *        The name of the slot type. The name is <i>not</i> case sensitive. </p>
         *        <p>
         *        The name can't match a built-in slot type name, or a built-in slot type name with "AMAZON." removed.
         *        For example, because there is a built-in slot type called <code>AMAZON.DATE</code>, you can't create a
         *        custom slot type called <code>DATE</code>.
         *        </p>
         *        <p>
         *        For a list of built-in slot types, see <a href=
         *        "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference"
         *        >Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the slot type.
         * </p>
         * 
         * @param description
         *        A description of the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take. Each
         * value can have a list of <code>synonyms</code>, which are additional values that help train the machine
         * learning model about the values that it resolves for a slot.
         * </p>
         * <p>
         * When Amazon Lex resolves a slot value, it generates a resolution list that contains up to five possible
         * values for the slot. If you are using a Lambda function, this resolution list is passed to the function. If
         * you are not using a Lambda function you can choose to return the value that the user entered or the first
         * value in the resolution list as the slot value. The <code>valueSelectionStrategy</code> field indicates the
         * option to use.
         * </p>
         * 
         * @param enumerationValues
         *        A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.
         *        Each value can have a list of <code>synonyms</code>, which are additional values that help train the
         *        machine learning model about the values that it resolves for a slot. </p>
         *        <p>
         *        When Amazon Lex resolves a slot value, it generates a resolution list that contains up to five
         *        possible values for the slot. If you are using a Lambda function, this resolution list is passed to
         *        the function. If you are not using a Lambda function you can choose to return the value that the user
         *        entered or the first value in the resolution list as the slot value. The
         *        <code>valueSelectionStrategy</code> field indicates the option to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enumerationValues(Collection<EnumerationValue> enumerationValues);

        /**
         * <p>
         * A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take. Each
         * value can have a list of <code>synonyms</code>, which are additional values that help train the machine
         * learning model about the values that it resolves for a slot.
         * </p>
         * <p>
         * When Amazon Lex resolves a slot value, it generates a resolution list that contains up to five possible
         * values for the slot. If you are using a Lambda function, this resolution list is passed to the function. If
         * you are not using a Lambda function you can choose to return the value that the user entered or the first
         * value in the resolution list as the slot value. The <code>valueSelectionStrategy</code> field indicates the
         * option to use.
         * </p>
         * 
         * @param enumerationValues
         *        A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.
         *        Each value can have a list of <code>synonyms</code>, which are additional values that help train the
         *        machine learning model about the values that it resolves for a slot. </p>
         *        <p>
         *        When Amazon Lex resolves a slot value, it generates a resolution list that contains up to five
         *        possible values for the slot. If you are using a Lambda function, this resolution list is passed to
         *        the function. If you are not using a Lambda function you can choose to return the value that the user
         *        entered or the first value in the resolution list as the slot value. The
         *        <code>valueSelectionStrategy</code> field indicates the option to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enumerationValues(EnumerationValue... enumerationValues);

        /**
         * <p>
         * A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take. Each
         * value can have a list of <code>synonyms</code>, which are additional values that help train the machine
         * learning model about the values that it resolves for a slot.
         * </p>
         * <p>
         * When Amazon Lex resolves a slot value, it generates a resolution list that contains up to five possible
         * values for the slot. If you are using a Lambda function, this resolution list is passed to the function. If
         * you are not using a Lambda function you can choose to return the value that the user entered or the first
         * value in the resolution list as the slot value. The <code>valueSelectionStrategy</code> field indicates the
         * option to use.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EnumerationValue>.Builder} avoiding the
         * need to create one manually via {@link List<EnumerationValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EnumerationValue>.Builder#build()} is called immediately and
         * its result is passed to {@link #enumerationValues(List<EnumerationValue>)}.
         * 
         * @param enumerationValues
         *        a consumer that will call methods on {@link List<EnumerationValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enumerationValues(List<EnumerationValue>)
         */
        Builder enumerationValues(Consumer<EnumerationValue.Builder>... enumerationValues);

        /**
         * <p>
         * Identifies a specific revision of the <code>$LATEST</code> version.
         * </p>
         * <p>
         * When you create a new slot type, leave the <code>checksum</code> field blank. If you specify a checksum you
         * get a <code>BadRequestException</code> exception.
         * </p>
         * <p>
         * When you want to update a slot type, set the <code>checksum</code> field to the checksum of the most recent
         * revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code> field, or if
         * the checksum does not match the <code>$LATEST</code> version, you get a
         * <code>PreconditionFailedException</code> exception.
         * </p>
         * 
         * @param checksum
         *        Identifies a specific revision of the <code>$LATEST</code> version.</p>
         *        <p>
         *        When you create a new slot type, leave the <code>checksum</code> field blank. If you specify a
         *        checksum you get a <code>BadRequestException</code> exception.
         *        </p>
         *        <p>
         *        When you want to update a slot type, set the <code>checksum</code> field to the checksum of the most
         *        recent revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code>
         *        field, or if the checksum does not match the <code>$LATEST</code> version, you get a
         *        <code>PreconditionFailedException</code> exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checksum(String checksum);

        /**
         * <p>
         * Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can be set
         * to one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to the slot
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in the
         * resolution list as the slot type value. If there is no resolution list, null is returned.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you don't specify the <code>valueSelectionStrategy</code>, the default is <code>ORIGINAL_VALUE</code>.
         * </p>
         * 
         * @param valueSelectionStrategy
         *        Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can
         *        be set to one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to
         *        the slot value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in
         *        the resolution list as the slot type value. If there is no resolution list, null is returned.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you don't specify the <code>valueSelectionStrategy</code>, the default is
         *        <code>ORIGINAL_VALUE</code>.
         * @see SlotValueSelectionStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlotValueSelectionStrategy
         */
        Builder valueSelectionStrategy(String valueSelectionStrategy);

        /**
         * <p>
         * Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can be set
         * to one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to the slot
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in the
         * resolution list as the slot type value. If there is no resolution list, null is returned.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you don't specify the <code>valueSelectionStrategy</code>, the default is <code>ORIGINAL_VALUE</code>.
         * </p>
         * 
         * @param valueSelectionStrategy
         *        Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can
         *        be set to one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to
         *        the slot value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in
         *        the resolution list as the slot type value. If there is no resolution list, null is returned.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you don't specify the <code>valueSelectionStrategy</code>, the default is
         *        <code>ORIGINAL_VALUE</code>.
         * @see SlotValueSelectionStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlotValueSelectionStrategy
         */
        Builder valueSelectionStrategy(SlotValueSelectionStrategy valueSelectionStrategy);

        /**
         * Sets the value of the CreateVersion property for this object.
         *
         * @param createVersion
         *        The new value for the CreateVersion property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createVersion(Boolean createVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelBuildingRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private List<EnumerationValue> enumerationValues = DefaultSdkAutoConstructList.getInstance();

        private String checksum;

        private String valueSelectionStrategy;

        private Boolean createVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSlotTypeRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            enumerationValues(model.enumerationValues);
            checksum(model.checksum);
            valueSelectionStrategy(model.valueSelectionStrategy);
            createVersion(model.createVersion);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<EnumerationValue.Builder> getEnumerationValues() {
            return enumerationValues != null ? enumerationValues.stream().map(EnumerationValue::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder enumerationValues(Collection<EnumerationValue> enumerationValues) {
            this.enumerationValues = EnumerationValuesCopier.copy(enumerationValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enumerationValues(EnumerationValue... enumerationValues) {
            enumerationValues(Arrays.asList(enumerationValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enumerationValues(Consumer<EnumerationValue.Builder>... enumerationValues) {
            enumerationValues(Stream.of(enumerationValues).map(c -> EnumerationValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEnumerationValues(Collection<EnumerationValue.BuilderImpl> enumerationValues) {
            this.enumerationValues = EnumerationValuesCopier.copyFromBuilder(enumerationValues);
        }

        public final String getChecksum() {
            return checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public final String getValueSelectionStrategy() {
            return valueSelectionStrategy;
        }

        @Override
        public final Builder valueSelectionStrategy(String valueSelectionStrategy) {
            this.valueSelectionStrategy = valueSelectionStrategy;
            return this;
        }

        @Override
        public final Builder valueSelectionStrategy(SlotValueSelectionStrategy valueSelectionStrategy) {
            this.valueSelectionStrategy(valueSelectionStrategy.toString());
            return this;
        }

        public final void setValueSelectionStrategy(String valueSelectionStrategy) {
            this.valueSelectionStrategy = valueSelectionStrategy;
        }

        public final Boolean getCreateVersion() {
            return createVersion;
        }

        @Override
        public final Builder createVersion(Boolean createVersion) {
            this.createVersion = createVersion;
            return this;
        }

        public final void setCreateVersion(Boolean createVersion) {
            this.createVersion = createVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutSlotTypeRequest build() {
            return new PutSlotTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
