/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelbuilding.model.Intent;
import software.amazon.awssdk.services.lexmodelbuilding.model.IntentListCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.Locale;
import software.amazon.awssdk.services.lexmodelbuilding.model.Prompt;
import software.amazon.awssdk.services.lexmodelbuilding.model.Statement;
import software.amazon.awssdk.services.lexmodelbuilding.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBotVersionResponse
extends LexModelBuildingResponse
implements ToCopyableBuilder<Builder, CreateBotVersionResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateBotVersionResponse.getter(CreateBotVersionResponse::name)).setter(CreateBotVersionResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateBotVersionResponse.getter(CreateBotVersionResponse::description)).setter(CreateBotVersionResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<Intent>> INTENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateBotVersionResponse.getter(CreateBotVersionResponse::intents)).setter(CreateBotVersionResponse.setter(Builder::intents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Intent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Prompt> CLARIFICATION_PROMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateBotVersionResponse.getter(CreateBotVersionResponse::clarificationPrompt)).setter(CreateBotVersionResponse.setter(Builder::clarificationPrompt)).constructor(Prompt::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clarificationPrompt").build()}).build();
    private static final SdkField<Statement> ABORT_STATEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateBotVersionResponse.getter(CreateBotVersionResponse::abortStatement)).setter(CreateBotVersionResponse.setter(Builder::abortStatement)).constructor(Statement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("abortStatement").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateBotVersionResponse.getter(CreateBotVersionResponse::statusAsString)).setter(CreateBotVersionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateBotVersionResponse.getter(CreateBotVersionResponse::failureReason)).setter(CreateBotVersionResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CreateBotVersionResponse.getter(CreateBotVersionResponse::lastUpdatedDate)).setter(CreateBotVersionResponse.setter(Builder::lastUpdatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDate").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CreateBotVersionResponse.getter(CreateBotVersionResponse::createdDate)).setter(CreateBotVersionResponse.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()}).build();
    private static final SdkField<Integer> IDLE_SESSION_TTL_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateBotVersionResponse.getter(CreateBotVersionResponse::idleSessionTTLInSeconds)).setter(CreateBotVersionResponse.setter(Builder::idleSessionTTLInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleSessionTTLInSeconds").build()}).build();
    private static final SdkField<String> VOICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateBotVersionResponse.getter(CreateBotVersionResponse::voiceId)).setter(CreateBotVersionResponse.setter(Builder::voiceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("voiceId").build()}).build();
    private static final SdkField<String> CHECKSUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateBotVersionResponse.getter(CreateBotVersionResponse::checksum)).setter(CreateBotVersionResponse.setter(Builder::checksum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checksum").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateBotVersionResponse.getter(CreateBotVersionResponse::version)).setter(CreateBotVersionResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateBotVersionResponse.getter(CreateBotVersionResponse::localeAsString)).setter(CreateBotVersionResponse.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locale").build()}).build();
    private static final SdkField<Boolean> CHILD_DIRECTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateBotVersionResponse.getter(CreateBotVersionResponse::childDirected)).setter(CreateBotVersionResponse.setter(Builder::childDirected)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childDirected").build()}).build();
    private static final SdkField<Boolean> DETECT_SENTIMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateBotVersionResponse.getter(CreateBotVersionResponse::detectSentiment)).setter(CreateBotVersionResponse.setter(Builder::detectSentiment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectSentiment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, INTENTS_FIELD, CLARIFICATION_PROMPT_FIELD, ABORT_STATEMENT_FIELD, STATUS_FIELD, FAILURE_REASON_FIELD, LAST_UPDATED_DATE_FIELD, CREATED_DATE_FIELD, IDLE_SESSION_TTL_IN_SECONDS_FIELD, VOICE_ID_FIELD, CHECKSUM_FIELD, VERSION_FIELD, LOCALE_FIELD, CHILD_DIRECTED_FIELD, DETECT_SENTIMENT_FIELD));
    private final String name;
    private final String description;
    private final List<Intent> intents;
    private final Prompt clarificationPrompt;
    private final Statement abortStatement;
    private final String status;
    private final String failureReason;
    private final Instant lastUpdatedDate;
    private final Instant createdDate;
    private final Integer idleSessionTTLInSeconds;
    private final String voiceId;
    private final String checksum;
    private final String version;
    private final String locale;
    private final Boolean childDirected;
    private final Boolean detectSentiment;

    private CreateBotVersionResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.intents = builder.intents;
        this.clarificationPrompt = builder.clarificationPrompt;
        this.abortStatement = builder.abortStatement;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.createdDate = builder.createdDate;
        this.idleSessionTTLInSeconds = builder.idleSessionTTLInSeconds;
        this.voiceId = builder.voiceId;
        this.checksum = builder.checksum;
        this.version = builder.version;
        this.locale = builder.locale;
        this.childDirected = builder.childDirected;
        this.detectSentiment = builder.detectSentiment;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public List<Intent> intents() {
        return this.intents;
    }

    public Prompt clarificationPrompt() {
        return this.clarificationPrompt;
    }

    public Statement abortStatement() {
        return this.abortStatement;
    }

    public Status status() {
        return Status.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public Instant lastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public Integer idleSessionTTLInSeconds() {
        return this.idleSessionTTLInSeconds;
    }

    public String voiceId() {
        return this.voiceId;
    }

    public String checksum() {
        return this.checksum;
    }

    public String version() {
        return this.version;
    }

    public Locale locale() {
        return Locale.fromValue(this.locale);
    }

    public String localeAsString() {
        return this.locale;
    }

    public Boolean childDirected() {
        return this.childDirected;
    }

    public Boolean detectSentiment() {
        return this.detectSentiment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.intents());
        hashCode = 31 * hashCode + Objects.hashCode(this.clarificationPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(this.abortStatement());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.idleSessionTTLInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.childDirected());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectSentiment());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBotVersionResponse)) {
            return false;
        }
        CreateBotVersionResponse other = (CreateBotVersionResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.intents(), other.intents()) && Objects.equals(this.clarificationPrompt(), other.clarificationPrompt()) && Objects.equals(this.abortStatement(), other.abortStatement()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.lastUpdatedDate(), other.lastUpdatedDate()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.idleSessionTTLInSeconds(), other.idleSessionTTLInSeconds()) && Objects.equals(this.voiceId(), other.voiceId()) && Objects.equals(this.checksum(), other.checksum()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.localeAsString(), other.localeAsString()) && Objects.equals(this.childDirected(), other.childDirected()) && Objects.equals(this.detectSentiment(), other.detectSentiment());
    }

    public String toString() {
        return ToString.builder((String)"CreateBotVersionResponse").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Intents", this.intents()).add("ClarificationPrompt", (Object)this.clarificationPrompt()).add("AbortStatement", (Object)this.abortStatement()).add("Status", (Object)this.statusAsString()).add("FailureReason", (Object)this.failureReason()).add("LastUpdatedDate", (Object)this.lastUpdatedDate()).add("CreatedDate", (Object)this.createdDate()).add("IdleSessionTTLInSeconds", (Object)this.idleSessionTTLInSeconds()).add("VoiceId", (Object)this.voiceId()).add("Checksum", (Object)this.checksum()).add("Version", (Object)this.version()).add("Locale", (Object)this.localeAsString()).add("ChildDirected", (Object)this.childDirected()).add("DetectSentiment", (Object)this.detectSentiment()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "intents": {
                return Optional.ofNullable(clazz.cast(this.intents()));
            }
            case "clarificationPrompt": {
                return Optional.ofNullable(clazz.cast(this.clarificationPrompt()));
            }
            case "abortStatement": {
                return Optional.ofNullable(clazz.cast(this.abortStatement()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "lastUpdatedDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDate()));
            }
            case "createdDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "idleSessionTTLInSeconds": {
                return Optional.ofNullable(clazz.cast(this.idleSessionTTLInSeconds()));
            }
            case "voiceId": {
                return Optional.ofNullable(clazz.cast(this.voiceId()));
            }
            case "checksum": {
                return Optional.ofNullable(clazz.cast(this.checksum()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "locale": {
                return Optional.ofNullable(clazz.cast(this.localeAsString()));
            }
            case "childDirected": {
                return Optional.ofNullable(clazz.cast(this.childDirected()));
            }
            case "detectSentiment": {
                return Optional.ofNullable(clazz.cast(this.detectSentiment()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBotVersionResponse, T> g) {
        return obj -> g.apply((CreateBotVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelBuildingResponse.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<Intent> intents = DefaultSdkAutoConstructList.getInstance();
        private Prompt clarificationPrompt;
        private Statement abortStatement;
        private String status;
        private String failureReason;
        private Instant lastUpdatedDate;
        private Instant createdDate;
        private Integer idleSessionTTLInSeconds;
        private String voiceId;
        private String checksum;
        private String version;
        private String locale;
        private Boolean childDirected;
        private Boolean detectSentiment;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBotVersionResponse model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.intents(model.intents);
            this.clarificationPrompt(model.clarificationPrompt);
            this.abortStatement(model.abortStatement);
            this.status(model.status);
            this.failureReason(model.failureReason);
            this.lastUpdatedDate(model.lastUpdatedDate);
            this.createdDate(model.createdDate);
            this.idleSessionTTLInSeconds(model.idleSessionTTLInSeconds);
            this.voiceId(model.voiceId);
            this.checksum(model.checksum);
            this.version(model.version);
            this.locale(model.locale);
            this.childDirected(model.childDirected);
            this.detectSentiment(model.detectSentiment);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Intent.Builder> getIntents() {
            return this.intents != null ? (Collection)this.intents.stream().map(Intent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder intents(Collection<Intent> intents) {
            this.intents = IntentListCopier.copy(intents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intents(Intent ... intents) {
            this.intents(Arrays.asList(intents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intents(Consumer<Intent.Builder> ... intents) {
            this.intents(Stream.of(intents).map(c -> (Intent)((Intent.Builder)Intent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIntents(Collection<Intent.BuilderImpl> intents) {
            this.intents = IntentListCopier.copyFromBuilder(intents);
        }

        public final Prompt.Builder getClarificationPrompt() {
            return this.clarificationPrompt != null ? this.clarificationPrompt.toBuilder() : null;
        }

        @Override
        public final Builder clarificationPrompt(Prompt clarificationPrompt) {
            this.clarificationPrompt = clarificationPrompt;
            return this;
        }

        public final void setClarificationPrompt(Prompt.BuilderImpl clarificationPrompt) {
            this.clarificationPrompt = clarificationPrompt != null ? clarificationPrompt.build() : null;
        }

        public final Statement.Builder getAbortStatement() {
            return this.abortStatement != null ? this.abortStatement.toBuilder() : null;
        }

        @Override
        public final Builder abortStatement(Statement abortStatement) {
            this.abortStatement = abortStatement;
            return this;
        }

        public final void setAbortStatement(Statement.BuilderImpl abortStatement) {
            this.abortStatement = abortStatement != null ? abortStatement.build() : null;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final Instant getLastUpdatedDate() {
            return this.lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final Integer getIdleSessionTTLInSeconds() {
            return this.idleSessionTTLInSeconds;
        }

        @Override
        public final Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
            return this;
        }

        public final void setIdleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
        }

        public final String getVoiceId() {
            return this.voiceId;
        }

        @Override
        public final Builder voiceId(String voiceId) {
            this.voiceId = voiceId;
            return this;
        }

        public final void setVoiceId(String voiceId) {
            this.voiceId = voiceId;
        }

        public final String getChecksum() {
            return this.checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getLocaleAsString() {
            return this.locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(Locale locale) {
            this.locale(locale == null ? null : locale.toString());
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        public final Boolean getChildDirected() {
            return this.childDirected;
        }

        @Override
        public final Builder childDirected(Boolean childDirected) {
            this.childDirected = childDirected;
            return this;
        }

        public final void setChildDirected(Boolean childDirected) {
            this.childDirected = childDirected;
        }

        public final Boolean getDetectSentiment() {
            return this.detectSentiment;
        }

        @Override
        public final Builder detectSentiment(Boolean detectSentiment) {
            this.detectSentiment = detectSentiment;
            return this;
        }

        public final void setDetectSentiment(Boolean detectSentiment) {
            this.detectSentiment = detectSentiment;
        }

        @Override
        public CreateBotVersionResponse build() {
            return new CreateBotVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelBuildingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBotVersionResponse> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder intents(Collection<Intent> var1);

        public Builder intents(Intent ... var1);

        public Builder intents(Consumer<Intent.Builder> ... var1);

        public Builder clarificationPrompt(Prompt var1);

        default public Builder clarificationPrompt(Consumer<Prompt.Builder> clarificationPrompt) {
            return this.clarificationPrompt((Prompt)((Prompt.Builder)Prompt.builder().applyMutation(clarificationPrompt)).build());
        }

        public Builder abortStatement(Statement var1);

        default public Builder abortStatement(Consumer<Statement.Builder> abortStatement) {
            return this.abortStatement((Statement)((Statement.Builder)Statement.builder().applyMutation(abortStatement)).build());
        }

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder failureReason(String var1);

        public Builder lastUpdatedDate(Instant var1);

        public Builder createdDate(Instant var1);

        public Builder idleSessionTTLInSeconds(Integer var1);

        public Builder voiceId(String var1);

        public Builder checksum(String var1);

        public Builder version(String var1);

        public Builder locale(String var1);

        public Builder locale(Locale var1);

        public Builder childDirected(Boolean var1);

        public Builder detectSentiment(Boolean var1);
    }
}

