/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetExportResponse extends LexModelBuildingResponse implements
        ToCopyableBuilder<GetExportResponse.Builder, GetExportResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetExportResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetExportResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetExportResponse::resourceTypeAsString)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> EXPORT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetExportResponse::exportTypeAsString)).setter(setter(Builder::exportType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportType").build()).build();

    private static final SdkField<String> EXPORT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetExportResponse::exportStatusAsString)).setter(setter(Builder::exportStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportStatus").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetExportResponse::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetExportResponse::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VERSION_FIELD,
            RESOURCE_TYPE_FIELD, EXPORT_TYPE_FIELD, EXPORT_STATUS_FIELD, FAILURE_REASON_FIELD, URL_FIELD));

    private final String name;

    private final String version;

    private final String resourceType;

    private final String exportType;

    private final String exportStatus;

    private final String failureReason;

    private final String url;

    private GetExportResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.version = builder.version;
        this.resourceType = builder.resourceType;
        this.exportType = builder.exportType;
        this.exportStatus = builder.exportStatus;
        this.failureReason = builder.failureReason;
        this.url = builder.url;
    }

    /**
     * <p>
     * The name of the bot being exported.
     * </p>
     * 
     * @return The name of the bot being exported.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The version of the bot being exported.
     * </p>
     * 
     * @return The version of the bot being exported.
     */
    public String version() {
        return version;
    }

    /**
     * <p>
     * The type of the exported resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of the exported resource.
     * @see ResourceType
     */
    public ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of the exported resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of the exported resource.
     * @see ResourceType
     */
    public String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The format of the exported data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportType} will
     * return {@link ExportType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportTypeAsString}.
     * </p>
     * 
     * @return The format of the exported data.
     * @see ExportType
     */
    public ExportType exportType() {
        return ExportType.fromValue(exportType);
    }

    /**
     * <p>
     * The format of the exported data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportType} will
     * return {@link ExportType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportTypeAsString}.
     * </p>
     * 
     * @return The format of the exported data.
     * @see ExportType
     */
    public String exportTypeAsString() {
        return exportType;
    }

    /**
     * <p>
     * The status of the export.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> - The export is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READY</code> - The export is complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The export could not be completed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportStatus} will
     * return {@link ExportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportStatusAsString}.
     * </p>
     * 
     * @return The status of the export. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> - The export is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READY</code> - The export is complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - The export could not be completed.
     *         </p>
     *         </li>
     * @see ExportStatus
     */
    public ExportStatus exportStatus() {
        return ExportStatus.fromValue(exportStatus);
    }

    /**
     * <p>
     * The status of the export.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> - The export is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READY</code> - The export is complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The export could not be completed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportStatus} will
     * return {@link ExportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportStatusAsString}.
     * </p>
     * 
     * @return The status of the export. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> - The export is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READY</code> - The export is complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - The export could not be completed.
     *         </p>
     *         </li>
     * @see ExportStatus
     */
    public String exportStatusAsString() {
        return exportStatus;
    }

    /**
     * <p>
     * If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to export the
     * resource.
     * </p>
     * 
     * @return If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to export
     *         the resource.
     */
    public String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * An S3 pre-signed URL that provides the location of the exported resource. The exported resource is a ZIP archive
     * that contains the exported resource in JSON format. The structure of the archive may change. Your code should not
     * rely on the archive structure.
     * </p>
     * 
     * @return An S3 pre-signed URL that provides the location of the exported resource. The exported resource is a ZIP
     *         archive that contains the exported resource in JSON format. The structure of the archive may change. Your
     *         code should not rely on the archive structure.
     */
    public String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(exportTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(exportStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExportResponse)) {
            return false;
        }
        GetExportResponse other = (GetExportResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(version(), other.version())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(exportTypeAsString(), other.exportTypeAsString())
                && Objects.equals(exportStatusAsString(), other.exportStatusAsString())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(url(), other.url());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetExportResponse").add("Name", name()).add("Version", version())
                .add("ResourceType", resourceTypeAsString()).add("ExportType", exportTypeAsString())
                .add("ExportStatus", exportStatusAsString()).add("FailureReason", failureReason()).add("Url", url()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "exportType":
            return Optional.ofNullable(clazz.cast(exportTypeAsString()));
        case "exportStatus":
            return Optional.ofNullable(clazz.cast(exportStatusAsString()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "url":
            return Optional.ofNullable(clazz.cast(url()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetExportResponse, T> g) {
        return obj -> g.apply((GetExportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelBuildingResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetExportResponse> {
        /**
         * <p>
         * The name of the bot being exported.
         * </p>
         * 
         * @param name
         *        The name of the bot being exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The version of the bot being exported.
         * </p>
         * 
         * @param version
         *        The version of the bot being exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The type of the exported resource.
         * </p>
         * 
         * @param resourceType
         *        The type of the exported resource.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of the exported resource.
         * </p>
         * 
         * @param resourceType
         *        The type of the exported resource.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The format of the exported data.
         * </p>
         * 
         * @param exportType
         *        The format of the exported data.
         * @see ExportType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportType
         */
        Builder exportType(String exportType);

        /**
         * <p>
         * The format of the exported data.
         * </p>
         * 
         * @param exportType
         *        The format of the exported data.
         * @see ExportType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportType
         */
        Builder exportType(ExportType exportType);

        /**
         * <p>
         * The status of the export.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> - The export is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READY</code> - The export is complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - The export could not be completed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param exportStatus
         *        The status of the export. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> - The export is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READY</code> - The export is complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - The export could not be completed.
         *        </p>
         *        </li>
         * @see ExportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportStatus
         */
        Builder exportStatus(String exportStatus);

        /**
         * <p>
         * The status of the export.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> - The export is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READY</code> - The export is complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - The export could not be completed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param exportStatus
         *        The status of the export. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> - The export is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READY</code> - The export is complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - The export could not be completed.
         *        </p>
         *        </li>
         * @see ExportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportStatus
         */
        Builder exportStatus(ExportStatus exportStatus);

        /**
         * <p>
         * If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to export the
         * resource.
         * </p>
         * 
         * @param failureReason
         *        If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to export
         *        the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * An S3 pre-signed URL that provides the location of the exported resource. The exported resource is a ZIP
         * archive that contains the exported resource in JSON format. The structure of the archive may change. Your
         * code should not rely on the archive structure.
         * </p>
         * 
         * @param url
         *        An S3 pre-signed URL that provides the location of the exported resource. The exported resource is a
         *        ZIP archive that contains the exported resource in JSON format. The structure of the archive may
         *        change. Your code should not rely on the archive structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    static final class BuilderImpl extends LexModelBuildingResponse.BuilderImpl implements Builder {
        private String name;

        private String version;

        private String resourceType;

        private String exportType;

        private String exportStatus;

        private String failureReason;

        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExportResponse model) {
            super(model);
            name(model.name);
            version(model.version);
            resourceType(model.resourceType);
            exportType(model.exportType);
            exportStatus(model.exportStatus);
            failureReason(model.failureReason);
            url(model.url);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getResourceTypeAsString() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getExportTypeAsString() {
            return exportType;
        }

        @Override
        public final Builder exportType(String exportType) {
            this.exportType = exportType;
            return this;
        }

        @Override
        public final Builder exportType(ExportType exportType) {
            this.exportType(exportType == null ? null : exportType.toString());
            return this;
        }

        public final void setExportType(String exportType) {
            this.exportType = exportType;
        }

        public final String getExportStatusAsString() {
            return exportStatus;
        }

        @Override
        public final Builder exportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
            return this;
        }

        @Override
        public final Builder exportStatus(ExportStatus exportStatus) {
            this.exportStatus(exportStatus == null ? null : exportStatus.toString());
            return this;
        }

        public final void setExportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public GetExportResponse build() {
            return new GetExportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
