/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBotAliasesResponse extends LexModelBuildingResponse implements
        ToCopyableBuilder<GetBotAliasesResponse.Builder, GetBotAliasesResponse> {
    private static final SdkField<List<BotAliasMetadata>> BOT_ALIASES_FIELD = SdkField
            .<List<BotAliasMetadata>> builder(MarshallingType.LIST)
            .getter(getter(GetBotAliasesResponse::botAliases))
            .setter(setter(Builder::botAliases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BotAliases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BotAliasMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(BotAliasMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetBotAliasesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ALIASES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<BotAliasMetadata> botAliases;

    private final String nextToken;

    private GetBotAliasesResponse(BuilderImpl builder) {
        super(builder);
        this.botAliases = builder.botAliases;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the BotAliases property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasBotAliases() {
        return botAliases != null && !(botAliases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>BotAliasMetadata</code> objects, each describing a bot alias.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBotAliases()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>BotAliasMetadata</code> objects, each describing a bot alias.
     */
    public List<BotAliasMetadata> botAliases() {
        return botAliases;
    }

    /**
     * <p>
     * A pagination token for fetching next page of aliases. If the response to this call is truncated, Amazon Lex
     * returns a pagination token in the response. To fetch the next page of aliases, specify the pagination token in
     * the next request.
     * </p>
     * 
     * @return A pagination token for fetching next page of aliases. If the response to this call is truncated, Amazon
     *         Lex returns a pagination token in the response. To fetch the next page of aliases, specify the pagination
     *         token in the next request.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botAliases());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBotAliasesResponse)) {
            return false;
        }
        GetBotAliasesResponse other = (GetBotAliasesResponse) obj;
        return Objects.equals(botAliases(), other.botAliases()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetBotAliasesResponse").add("BotAliases", botAliases()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BotAliases":
            return Optional.ofNullable(clazz.cast(botAliases()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBotAliasesResponse, T> g) {
        return obj -> g.apply((GetBotAliasesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelBuildingResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetBotAliasesResponse> {
        /**
         * <p>
         * An array of <code>BotAliasMetadata</code> objects, each describing a bot alias.
         * </p>
         * 
         * @param botAliases
         *        An array of <code>BotAliasMetadata</code> objects, each describing a bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliases(Collection<BotAliasMetadata> botAliases);

        /**
         * <p>
         * An array of <code>BotAliasMetadata</code> objects, each describing a bot alias.
         * </p>
         * 
         * @param botAliases
         *        An array of <code>BotAliasMetadata</code> objects, each describing a bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliases(BotAliasMetadata... botAliases);

        /**
         * <p>
         * An array of <code>BotAliasMetadata</code> objects, each describing a bot alias.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BotAliasMetadata>.Builder} avoiding the
         * need to create one manually via {@link List<BotAliasMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BotAliasMetadata>.Builder#build()} is called immediately and
         * its result is passed to {@link #botAliases(List<BotAliasMetadata>)}.
         * 
         * @param botAliases
         *        a consumer that will call methods on {@link List<BotAliasMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #botAliases(List<BotAliasMetadata>)
         */
        Builder botAliases(Consumer<BotAliasMetadata.Builder>... botAliases);

        /**
         * <p>
         * A pagination token for fetching next page of aliases. If the response to this call is truncated, Amazon Lex
         * returns a pagination token in the response. To fetch the next page of aliases, specify the pagination token
         * in the next request.
         * </p>
         * 
         * @param nextToken
         *        A pagination token for fetching next page of aliases. If the response to this call is truncated,
         *        Amazon Lex returns a pagination token in the response. To fetch the next page of aliases, specify the
         *        pagination token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LexModelBuildingResponse.BuilderImpl implements Builder {
        private List<BotAliasMetadata> botAliases = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBotAliasesResponse model) {
            super(model);
            botAliases(model.botAliases);
            nextToken(model.nextToken);
        }

        public final Collection<BotAliasMetadata.Builder> getBotAliases() {
            return botAliases != null ? botAliases.stream().map(BotAliasMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder botAliases(Collection<BotAliasMetadata> botAliases) {
            this.botAliases = BotAliasMetadataListCopier.copy(botAliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botAliases(BotAliasMetadata... botAliases) {
            botAliases(Arrays.asList(botAliases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botAliases(Consumer<BotAliasMetadata.Builder>... botAliases) {
            botAliases(Stream.of(botAliases).map(c -> BotAliasMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setBotAliases(Collection<BotAliasMetadata.BuilderImpl> botAliases) {
            this.botAliases = BotAliasMetadataListCopier.copyFromBuilder(botAliases);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetBotAliasesResponse build() {
            return new GetBotAliasesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
