/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.ListsOfUtterancesCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.UtteranceList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetUtterancesViewResponse
extends LexModelBuildingResponse
implements ToCopyableBuilder<Builder, GetUtterancesViewResponse> {
    private static final SdkField<String> BOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetUtterancesViewResponse.getter(GetUtterancesViewResponse::botName)).setter(GetUtterancesViewResponse.setter(Builder::botName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botName").build()}).build();
    private static final SdkField<List<UtteranceList>> UTTERANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetUtterancesViewResponse.getter(GetUtterancesViewResponse::utterances)).setter(GetUtterancesViewResponse.setter(Builder::utterances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("utterances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UtteranceList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_NAME_FIELD, UTTERANCES_FIELD));
    private final String botName;
    private final List<UtteranceList> utterances;

    private GetUtterancesViewResponse(BuilderImpl builder) {
        super(builder);
        this.botName = builder.botName;
        this.utterances = builder.utterances;
    }

    public String botName() {
        return this.botName;
    }

    public boolean hasUtterances() {
        return this.utterances != null && !(this.utterances instanceof SdkAutoConstructList);
    }

    public List<UtteranceList> utterances() {
        return this.utterances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botName());
        hashCode = 31 * hashCode + Objects.hashCode(this.utterances());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUtterancesViewResponse)) {
            return false;
        }
        GetUtterancesViewResponse other = (GetUtterancesViewResponse)((Object)obj);
        return Objects.equals(this.botName(), other.botName()) && Objects.equals(this.utterances(), other.utterances());
    }

    public String toString() {
        return ToString.builder((String)"GetUtterancesViewResponse").add("BotName", (Object)this.botName()).add("Utterances", this.utterances()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botName": {
                return Optional.ofNullable(clazz.cast(this.botName()));
            }
            case "utterances": {
                return Optional.ofNullable(clazz.cast(this.utterances()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUtterancesViewResponse, T> g) {
        return obj -> g.apply((GetUtterancesViewResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelBuildingResponse.BuilderImpl
    implements Builder {
        private String botName;
        private List<UtteranceList> utterances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetUtterancesViewResponse model) {
            super(model);
            this.botName(model.botName);
            this.utterances(model.utterances);
        }

        public final String getBotName() {
            return this.botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        public final Collection<UtteranceList.Builder> getUtterances() {
            return this.utterances != null ? (Collection)this.utterances.stream().map(UtteranceList::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder utterances(Collection<UtteranceList> utterances) {
            this.utterances = ListsOfUtterancesCopier.copy(utterances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utterances(UtteranceList ... utterances) {
            this.utterances(Arrays.asList(utterances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utterances(Consumer<UtteranceList.Builder> ... utterances) {
            this.utterances(Stream.of(utterances).map(c -> (UtteranceList)((UtteranceList.Builder)UtteranceList.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUtterances(Collection<UtteranceList.BuilderImpl> utterances) {
            this.utterances = ListsOfUtterancesCopier.copyFromBuilder(utterances);
        }

        @Override
        public GetUtterancesViewResponse build() {
            return new GetUtterancesViewResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelBuildingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetUtterancesViewResponse> {
        public Builder botName(String var1);

        public Builder utterances(Collection<UtteranceList> var1);

        public Builder utterances(UtteranceList ... var1);

        public Builder utterances(Consumer<UtteranceList.Builder> ... var1);
    }
}

