/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The resource that you are attempting to delete is referred to by another resource. Use this information to remove
 * references to the resource that you are trying to delete.
 * </p>
 * <p>
 * The body of the exception contains a JSON object that describes the resource.
 * </p>
 * <p>
 * <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code>
 * </p>
 * <p>
 * <code>"resourceReference": {</code>
 * </p>
 * <p>
 * <code>"name": <i>string</i>, "version": <i>string</i> } }</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceInUseException extends LexModelBuildingException implements
        ToCopyableBuilder<ResourceInUseException.Builder, ResourceInUseException> {
    private static final SdkField<String> REFERENCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceInUseException::referenceTypeAsString)).setter(setter(Builder::referenceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceType").build()).build();

    private static final SdkField<ResourceReference> EXAMPLE_REFERENCE_FIELD = SdkField
            .<ResourceReference> builder(MarshallingType.SDK_POJO).getter(getter(ResourceInUseException::exampleReference))
            .setter(setter(Builder::exampleReference)).constructor(ResourceReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exampleReference").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFERENCE_TYPE_FIELD,
            EXAMPLE_REFERENCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String referenceType;

    private final ResourceReference exampleReference;

    private ResourceInUseException(BuilderImpl builder) {
        super(builder);
        this.referenceType = builder.referenceType;
        this.exampleReference = builder.exampleReference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the ReferenceType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #referenceType}
     * will return {@link ReferenceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #referenceTypeAsString}.
     * </p>
     * 
     * @return The value of the ReferenceType property for this object.
     * @see ReferenceType
     */
    public ReferenceType referenceType() {
        return ReferenceType.fromValue(referenceType);
    }

    /**
     * Returns the value of the ReferenceType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #referenceType}
     * will return {@link ReferenceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #referenceTypeAsString}.
     * </p>
     * 
     * @return The value of the ReferenceType property for this object.
     * @see ReferenceType
     */
    public String referenceTypeAsString() {
        return referenceType;
    }

    /**
     * Returns the value of the ExampleReference property for this object.
     * 
     * @return The value of the ExampleReference property for this object.
     */
    public ResourceReference exampleReference() {
        return exampleReference;
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceInUseException, T> g) {
        return obj -> g.apply((ResourceInUseException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceInUseException>, LexModelBuildingException.Builder {
        /**
         * Sets the value of the ReferenceType property for this object.
         *
         * @param referenceType
         *        The new value for the ReferenceType property for this object.
         * @see ReferenceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReferenceType
         */
        Builder referenceType(String referenceType);

        /**
         * Sets the value of the ReferenceType property for this object.
         *
         * @param referenceType
         *        The new value for the ReferenceType property for this object.
         * @see ReferenceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReferenceType
         */
        Builder referenceType(ReferenceType referenceType);

        /**
         * Sets the value of the ExampleReference property for this object.
         *
         * @param exampleReference
         *        The new value for the ExampleReference property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exampleReference(ResourceReference exampleReference);

        /**
         * Sets the value of the ExampleReference property for this object.
         *
         * This is a convenience that creates an instance of the {@link ResourceReference.Builder} avoiding the need to
         * create one manually via {@link ResourceReference#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceReference.Builder#build()} is called immediately and its
         * result is passed to {@link #exampleReference(ResourceReference)}.
         * 
         * @param exampleReference
         *        a consumer that will call methods on {@link ResourceReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exampleReference(ResourceReference)
         */
        default Builder exampleReference(Consumer<ResourceReference.Builder> exampleReference) {
            return exampleReference(ResourceReference.builder().applyMutation(exampleReference).build());
        }

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends LexModelBuildingException.BuilderImpl implements Builder {
        private String referenceType;

        private ResourceReference exampleReference;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceInUseException model) {
            super(model);
            referenceType(model.referenceType);
            exampleReference(model.exampleReference);
        }

        public final String getReferenceTypeAsString() {
            return referenceType;
        }

        @Override
        public final Builder referenceType(String referenceType) {
            this.referenceType = referenceType;
            return this;
        }

        @Override
        public final Builder referenceType(ReferenceType referenceType) {
            this.referenceType(referenceType == null ? null : referenceType.toString());
            return this;
        }

        public final void setReferenceType(String referenceType) {
            this.referenceType = referenceType;
        }

        public final ResourceReference.Builder getExampleReference() {
            return exampleReference != null ? exampleReference.toBuilder() : null;
        }

        @Override
        public final Builder exampleReference(ResourceReference exampleReference) {
            this.exampleReference = exampleReference;
            return this;
        }

        public final void setExampleReference(ResourceReference.BuilderImpl exampleReference) {
            this.exampleReference = exampleReference != null ? exampleReference.build() : null;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public ResourceInUseException build() {
            return new ResourceInUseException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
