/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a built in slot type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BuiltinSlotTypeMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<BuiltinSlotTypeMetadata.Builder, BuiltinSlotTypeMetadata> {
    private static final SdkField<String> SIGNATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BuiltinSlotTypeMetadata::signature)).setter(setter(Builder::signature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signature").build()).build();

    private static final SdkField<List<String>> SUPPORTED_LOCALES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(BuiltinSlotTypeMetadata::supportedLocalesAsStrings))
            .setter(setter(Builder::supportedLocalesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedLocales").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNATURE_FIELD,
            SUPPORTED_LOCALES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String signature;

    private final List<String> supportedLocales;

    private BuiltinSlotTypeMetadata(BuilderImpl builder) {
        this.signature = builder.signature;
        this.supportedLocales = builder.supportedLocales;
    }

    /**
     * <p>
     * A unique identifier for the built-in slot type. To find the signature for a slot type, see <a href=
     * "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference"
     * >Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.
     * </p>
     * 
     * @return A unique identifier for the built-in slot type. To find the signature for a slot type, see <a href=
     *         "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference"
     *         >Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.
     */
    public String signature() {
        return signature;
    }

    /**
     * <p>
     * A list of target locales for the slot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupportedLocales()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of target locales for the slot.
     */
    public List<Locale> supportedLocales() {
        return LocaleListCopier.copyStringToEnum(supportedLocales);
    }

    /**
     * Returns true if the SupportedLocales property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSupportedLocales() {
        return supportedLocales != null && !(supportedLocales instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of target locales for the slot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupportedLocales()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of target locales for the slot.
     */
    public List<String> supportedLocalesAsStrings() {
        return supportedLocales;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(signature());
        hashCode = 31 * hashCode + Objects.hashCode(supportedLocalesAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuiltinSlotTypeMetadata)) {
            return false;
        }
        BuiltinSlotTypeMetadata other = (BuiltinSlotTypeMetadata) obj;
        return Objects.equals(signature(), other.signature())
                && Objects.equals(supportedLocalesAsStrings(), other.supportedLocalesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BuiltinSlotTypeMetadata").add("Signature", signature())
                .add("SupportedLocales", supportedLocalesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "signature":
            return Optional.ofNullable(clazz.cast(signature()));
        case "supportedLocales":
            return Optional.ofNullable(clazz.cast(supportedLocalesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BuiltinSlotTypeMetadata, T> g) {
        return obj -> g.apply((BuiltinSlotTypeMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BuiltinSlotTypeMetadata> {
        /**
         * <p>
         * A unique identifier for the built-in slot type. To find the signature for a slot type, see <a href=
         * "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference"
         * >Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.
         * </p>
         * 
         * @param signature
         *        A unique identifier for the built-in slot type. To find the signature for a slot type, see <a href=
         *        "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference"
         *        >Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signature(String signature);

        /**
         * <p>
         * A list of target locales for the slot.
         * </p>
         * 
         * @param supportedLocales
         *        A list of target locales for the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedLocalesWithStrings(Collection<String> supportedLocales);

        /**
         * <p>
         * A list of target locales for the slot.
         * </p>
         * 
         * @param supportedLocales
         *        A list of target locales for the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedLocalesWithStrings(String... supportedLocales);

        /**
         * <p>
         * A list of target locales for the slot.
         * </p>
         * 
         * @param supportedLocales
         *        A list of target locales for the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedLocales(Collection<Locale> supportedLocales);

        /**
         * <p>
         * A list of target locales for the slot.
         * </p>
         * 
         * @param supportedLocales
         *        A list of target locales for the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedLocales(Locale... supportedLocales);
    }

    static final class BuilderImpl implements Builder {
        private String signature;

        private List<String> supportedLocales = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BuiltinSlotTypeMetadata model) {
            signature(model.signature);
            supportedLocalesWithStrings(model.supportedLocales);
        }

        public final String getSignature() {
            return signature;
        }

        @Override
        public final Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public final void setSignature(String signature) {
            this.signature = signature;
        }

        public final Collection<String> getSupportedLocalesAsStrings() {
            return supportedLocales;
        }

        @Override
        public final Builder supportedLocalesWithStrings(Collection<String> supportedLocales) {
            this.supportedLocales = LocaleListCopier.copy(supportedLocales);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedLocalesWithStrings(String... supportedLocales) {
            supportedLocalesWithStrings(Arrays.asList(supportedLocales));
            return this;
        }

        @Override
        public final Builder supportedLocales(Collection<Locale> supportedLocales) {
            this.supportedLocales = LocaleListCopier.copyEnumToString(supportedLocales);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedLocales(Locale... supportedLocales) {
            supportedLocales(Arrays.asList(supportedLocales));
            return this;
        }

        public final void setSupportedLocalesWithStrings(Collection<String> supportedLocales) {
            this.supportedLocales = LocaleListCopier.copy(supportedLocales);
        }

        @Override
        public BuiltinSlotTypeMetadata build() {
            return new BuiltinSlotTypeMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
