/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSlotTypeVersionResponse extends LexModelBuildingResponse implements
        ToCopyableBuilder<CreateSlotTypeVersionResponse.Builder, CreateSlotTypeVersionResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSlotTypeVersionResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSlotTypeVersionResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<EnumerationValue>> ENUMERATION_VALUES_FIELD = SdkField
            .<List<EnumerationValue>> builder(MarshallingType.LIST)
            .getter(getter(CreateSlotTypeVersionResponse::enumerationValues))
            .setter(setter(Builder::enumerationValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enumerationValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnumerationValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnumerationValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(CreateSlotTypeVersionResponse::lastUpdatedDate)).setter(setter(Builder::lastUpdatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDate").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(CreateSlotTypeVersionResponse::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSlotTypeVersionResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> CHECKSUM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSlotTypeVersionResponse::checksum)).setter(setter(Builder::checksum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checksum").build()).build();

    private static final SdkField<String> VALUE_SELECTION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSlotTypeVersionResponse::valueSelectionStrategyAsString))
            .setter(setter(Builder::valueSelectionStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueSelectionStrategy").build())
            .build();

    private static final SdkField<String> PARENT_SLOT_TYPE_SIGNATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSlotTypeVersionResponse::parentSlotTypeSignature))
            .setter(setter(Builder::parentSlotTypeSignature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentSlotTypeSignature").build())
            .build();

    private static final SdkField<List<SlotTypeConfiguration>> SLOT_TYPE_CONFIGURATIONS_FIELD = SdkField
            .<List<SlotTypeConfiguration>> builder(MarshallingType.LIST)
            .getter(getter(CreateSlotTypeVersionResponse::slotTypeConfigurations))
            .setter(setter(Builder::slotTypeConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypeConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SlotTypeConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(SlotTypeConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            ENUMERATION_VALUES_FIELD, LAST_UPDATED_DATE_FIELD, CREATED_DATE_FIELD, VERSION_FIELD, CHECKSUM_FIELD,
            VALUE_SELECTION_STRATEGY_FIELD, PARENT_SLOT_TYPE_SIGNATURE_FIELD, SLOT_TYPE_CONFIGURATIONS_FIELD));

    private final String name;

    private final String description;

    private final List<EnumerationValue> enumerationValues;

    private final Instant lastUpdatedDate;

    private final Instant createdDate;

    private final String version;

    private final String checksum;

    private final String valueSelectionStrategy;

    private final String parentSlotTypeSignature;

    private final List<SlotTypeConfiguration> slotTypeConfigurations;

    private CreateSlotTypeVersionResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.enumerationValues = builder.enumerationValues;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.createdDate = builder.createdDate;
        this.version = builder.version;
        this.checksum = builder.checksum;
        this.valueSelectionStrategy = builder.valueSelectionStrategy;
        this.parentSlotTypeSignature = builder.parentSlotTypeSignature;
        this.slotTypeConfigurations = builder.slotTypeConfigurations;
    }

    /**
     * <p>
     * The name of the slot type.
     * </p>
     * 
     * @return The name of the slot type.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A description of the slot type.
     * </p>
     * 
     * @return A description of the slot type.
     */
    public String description() {
        return description;
    }

    /**
     * Returns true if the EnumerationValues property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasEnumerationValues() {
        return enumerationValues != null && !(enumerationValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEnumerationValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.
     */
    public List<EnumerationValue> enumerationValues() {
        return enumerationValues;
    }

    /**
     * <p>
     * The date that the slot type was updated. When you create a resource, the creation date and last update date are
     * the same.
     * </p>
     * 
     * @return The date that the slot type was updated. When you create a resource, the creation date and last update
     *         date are the same.
     */
    public Instant lastUpdatedDate() {
        return lastUpdatedDate;
    }

    /**
     * <p>
     * The date that the slot type was created.
     * </p>
     * 
     * @return The date that the slot type was created.
     */
    public Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The version assigned to the new slot type version.
     * </p>
     * 
     * @return The version assigned to the new slot type version.
     */
    public String version() {
        return version;
    }

    /**
     * <p>
     * Checksum of the <code>$LATEST</code> version of the slot type.
     * </p>
     * 
     * @return Checksum of the <code>$LATEST</code> version of the slot type.
     */
    public String checksum() {
        return checksum;
    }

    /**
     * <p>
     * The strategy that Amazon Lex uses to determine the value of the slot. For more information, see
     * <a>PutSlotType</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #valueSelectionStrategy} will return {@link SlotValueSelectionStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #valueSelectionStrategyAsString}.
     * </p>
     * 
     * @return The strategy that Amazon Lex uses to determine the value of the slot. For more information, see
     *         <a>PutSlotType</a>.
     * @see SlotValueSelectionStrategy
     */
    public SlotValueSelectionStrategy valueSelectionStrategy() {
        return SlotValueSelectionStrategy.fromValue(valueSelectionStrategy);
    }

    /**
     * <p>
     * The strategy that Amazon Lex uses to determine the value of the slot. For more information, see
     * <a>PutSlotType</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #valueSelectionStrategy} will return {@link SlotValueSelectionStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #valueSelectionStrategyAsString}.
     * </p>
     * 
     * @return The strategy that Amazon Lex uses to determine the value of the slot. For more information, see
     *         <a>PutSlotType</a>.
     * @see SlotValueSelectionStrategy
     */
    public String valueSelectionStrategyAsString() {
        return valueSelectionStrategy;
    }

    /**
     * <p>
     * The built-in slot type used a the parent of the slot type.
     * </p>
     * 
     * @return The built-in slot type used a the parent of the slot type.
     */
    public String parentSlotTypeSignature() {
        return parentSlotTypeSignature;
    }

    /**
     * Returns true if the SlotTypeConfigurations property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSlotTypeConfigurations() {
        return slotTypeConfigurations != null && !(slotTypeConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configuration information that extends the parent built-in slot type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSlotTypeConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Configuration information that extends the parent built-in slot type.
     */
    public List<SlotTypeConfiguration> slotTypeConfigurations() {
        return slotTypeConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(enumerationValues());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(checksum());
        hashCode = 31 * hashCode + Objects.hashCode(valueSelectionStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(parentSlotTypeSignature());
        hashCode = 31 * hashCode + Objects.hashCode(slotTypeConfigurations());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSlotTypeVersionResponse)) {
            return false;
        }
        CreateSlotTypeVersionResponse other = (CreateSlotTypeVersionResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(enumerationValues(), other.enumerationValues())
                && Objects.equals(lastUpdatedDate(), other.lastUpdatedDate())
                && Objects.equals(createdDate(), other.createdDate()) && Objects.equals(version(), other.version())
                && Objects.equals(checksum(), other.checksum())
                && Objects.equals(valueSelectionStrategyAsString(), other.valueSelectionStrategyAsString())
                && Objects.equals(parentSlotTypeSignature(), other.parentSlotTypeSignature())
                && Objects.equals(slotTypeConfigurations(), other.slotTypeConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateSlotTypeVersionResponse").add("Name", name()).add("Description", description())
                .add("EnumerationValues", enumerationValues()).add("LastUpdatedDate", lastUpdatedDate())
                .add("CreatedDate", createdDate()).add("Version", version()).add("Checksum", checksum())
                .add("ValueSelectionStrategy", valueSelectionStrategyAsString())
                .add("ParentSlotTypeSignature", parentSlotTypeSignature())
                .add("SlotTypeConfigurations", slotTypeConfigurations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "enumerationValues":
            return Optional.ofNullable(clazz.cast(enumerationValues()));
        case "lastUpdatedDate":
            return Optional.ofNullable(clazz.cast(lastUpdatedDate()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "checksum":
            return Optional.ofNullable(clazz.cast(checksum()));
        case "valueSelectionStrategy":
            return Optional.ofNullable(clazz.cast(valueSelectionStrategyAsString()));
        case "parentSlotTypeSignature":
            return Optional.ofNullable(clazz.cast(parentSlotTypeSignature()));
        case "slotTypeConfigurations":
            return Optional.ofNullable(clazz.cast(slotTypeConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSlotTypeVersionResponse, T> g) {
        return obj -> g.apply((CreateSlotTypeVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelBuildingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSlotTypeVersionResponse> {
        /**
         * <p>
         * The name of the slot type.
         * </p>
         * 
         * @param name
         *        The name of the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the slot type.
         * </p>
         * 
         * @param description
         *        A description of the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.
         * </p>
         * 
         * @param enumerationValues
         *        A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enumerationValues(Collection<EnumerationValue> enumerationValues);

        /**
         * <p>
         * A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.
         * </p>
         * 
         * @param enumerationValues
         *        A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enumerationValues(EnumerationValue... enumerationValues);

        /**
         * <p>
         * A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EnumerationValue>.Builder} avoiding the
         * need to create one manually via {@link List<EnumerationValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EnumerationValue>.Builder#build()} is called immediately and
         * its result is passed to {@link #enumerationValues(List<EnumerationValue>)}.
         * 
         * @param enumerationValues
         *        a consumer that will call methods on {@link List<EnumerationValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enumerationValues(List<EnumerationValue>)
         */
        Builder enumerationValues(Consumer<EnumerationValue.Builder>... enumerationValues);

        /**
         * <p>
         * The date that the slot type was updated. When you create a resource, the creation date and last update date
         * are the same.
         * </p>
         * 
         * @param lastUpdatedDate
         *        The date that the slot type was updated. When you create a resource, the creation date and last update
         *        date are the same.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(Instant lastUpdatedDate);

        /**
         * <p>
         * The date that the slot type was created.
         * </p>
         * 
         * @param createdDate
         *        The date that the slot type was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The version assigned to the new slot type version.
         * </p>
         * 
         * @param version
         *        The version assigned to the new slot type version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * Checksum of the <code>$LATEST</code> version of the slot type.
         * </p>
         * 
         * @param checksum
         *        Checksum of the <code>$LATEST</code> version of the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checksum(String checksum);

        /**
         * <p>
         * The strategy that Amazon Lex uses to determine the value of the slot. For more information, see
         * <a>PutSlotType</a>.
         * </p>
         * 
         * @param valueSelectionStrategy
         *        The strategy that Amazon Lex uses to determine the value of the slot. For more information, see
         *        <a>PutSlotType</a>.
         * @see SlotValueSelectionStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlotValueSelectionStrategy
         */
        Builder valueSelectionStrategy(String valueSelectionStrategy);

        /**
         * <p>
         * The strategy that Amazon Lex uses to determine the value of the slot. For more information, see
         * <a>PutSlotType</a>.
         * </p>
         * 
         * @param valueSelectionStrategy
         *        The strategy that Amazon Lex uses to determine the value of the slot. For more information, see
         *        <a>PutSlotType</a>.
         * @see SlotValueSelectionStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlotValueSelectionStrategy
         */
        Builder valueSelectionStrategy(SlotValueSelectionStrategy valueSelectionStrategy);

        /**
         * <p>
         * The built-in slot type used a the parent of the slot type.
         * </p>
         * 
         * @param parentSlotTypeSignature
         *        The built-in slot type used a the parent of the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentSlotTypeSignature(String parentSlotTypeSignature);

        /**
         * <p>
         * Configuration information that extends the parent built-in slot type.
         * </p>
         * 
         * @param slotTypeConfigurations
         *        Configuration information that extends the parent built-in slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypeConfigurations(Collection<SlotTypeConfiguration> slotTypeConfigurations);

        /**
         * <p>
         * Configuration information that extends the parent built-in slot type.
         * </p>
         * 
         * @param slotTypeConfigurations
         *        Configuration information that extends the parent built-in slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypeConfigurations(SlotTypeConfiguration... slotTypeConfigurations);

        /**
         * <p>
         * Configuration information that extends the parent built-in slot type.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SlotTypeConfiguration>.Builder} avoiding
         * the need to create one manually via {@link List<SlotTypeConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SlotTypeConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #slotTypeConfigurations(List<SlotTypeConfiguration>)}.
         * 
         * @param slotTypeConfigurations
         *        a consumer that will call methods on {@link List<SlotTypeConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slotTypeConfigurations(List<SlotTypeConfiguration>)
         */
        Builder slotTypeConfigurations(Consumer<SlotTypeConfiguration.Builder>... slotTypeConfigurations);
    }

    static final class BuilderImpl extends LexModelBuildingResponse.BuilderImpl implements Builder {
        private String name;

        private String description;

        private List<EnumerationValue> enumerationValues = DefaultSdkAutoConstructList.getInstance();

        private Instant lastUpdatedDate;

        private Instant createdDate;

        private String version;

        private String checksum;

        private String valueSelectionStrategy;

        private String parentSlotTypeSignature;

        private List<SlotTypeConfiguration> slotTypeConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSlotTypeVersionResponse model) {
            super(model);
            name(model.name);
            description(model.description);
            enumerationValues(model.enumerationValues);
            lastUpdatedDate(model.lastUpdatedDate);
            createdDate(model.createdDate);
            version(model.version);
            checksum(model.checksum);
            valueSelectionStrategy(model.valueSelectionStrategy);
            parentSlotTypeSignature(model.parentSlotTypeSignature);
            slotTypeConfigurations(model.slotTypeConfigurations);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<EnumerationValue.Builder> getEnumerationValues() {
            return enumerationValues != null ? enumerationValues.stream().map(EnumerationValue::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder enumerationValues(Collection<EnumerationValue> enumerationValues) {
            this.enumerationValues = EnumerationValuesCopier.copy(enumerationValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enumerationValues(EnumerationValue... enumerationValues) {
            enumerationValues(Arrays.asList(enumerationValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enumerationValues(Consumer<EnumerationValue.Builder>... enumerationValues) {
            enumerationValues(Stream.of(enumerationValues).map(c -> EnumerationValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEnumerationValues(Collection<EnumerationValue.BuilderImpl> enumerationValues) {
            this.enumerationValues = EnumerationValuesCopier.copyFromBuilder(enumerationValues);
        }

        public final Instant getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getChecksum() {
            return checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public final String getValueSelectionStrategyAsString() {
            return valueSelectionStrategy;
        }

        @Override
        public final Builder valueSelectionStrategy(String valueSelectionStrategy) {
            this.valueSelectionStrategy = valueSelectionStrategy;
            return this;
        }

        @Override
        public final Builder valueSelectionStrategy(SlotValueSelectionStrategy valueSelectionStrategy) {
            this.valueSelectionStrategy(valueSelectionStrategy == null ? null : valueSelectionStrategy.toString());
            return this;
        }

        public final void setValueSelectionStrategy(String valueSelectionStrategy) {
            this.valueSelectionStrategy = valueSelectionStrategy;
        }

        public final String getParentSlotTypeSignature() {
            return parentSlotTypeSignature;
        }

        @Override
        public final Builder parentSlotTypeSignature(String parentSlotTypeSignature) {
            this.parentSlotTypeSignature = parentSlotTypeSignature;
            return this;
        }

        public final void setParentSlotTypeSignature(String parentSlotTypeSignature) {
            this.parentSlotTypeSignature = parentSlotTypeSignature;
        }

        public final Collection<SlotTypeConfiguration.Builder> getSlotTypeConfigurations() {
            return slotTypeConfigurations != null ? slotTypeConfigurations.stream().map(SlotTypeConfiguration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder slotTypeConfigurations(Collection<SlotTypeConfiguration> slotTypeConfigurations) {
            this.slotTypeConfigurations = SlotTypeConfigurationsCopier.copy(slotTypeConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotTypeConfigurations(SlotTypeConfiguration... slotTypeConfigurations) {
            slotTypeConfigurations(Arrays.asList(slotTypeConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotTypeConfigurations(Consumer<SlotTypeConfiguration.Builder>... slotTypeConfigurations) {
            slotTypeConfigurations(Stream.of(slotTypeConfigurations)
                    .map(c -> SlotTypeConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSlotTypeConfigurations(Collection<SlotTypeConfiguration.BuilderImpl> slotTypeConfigurations) {
            this.slotTypeConfigurations = SlotTypeConfigurationsCopier.copyFromBuilder(slotTypeConfigurations);
        }

        @Override
        public CreateSlotTypeVersionResponse build() {
            return new CreateSlotTypeVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
