/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIntentVersionResponse extends LexModelBuildingResponse implements
        ToCopyableBuilder<CreateIntentVersionResponse.Builder, CreateIntentVersionResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateIntentVersionResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateIntentVersionResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<Slot>> SLOTS_FIELD = SdkField
            .<List<Slot>> builder(MarshallingType.LIST)
            .getter(getter(CreateIntentVersionResponse::slots))
            .setter(setter(Builder::slots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slots").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Slot> builder(MarshallingType.SDK_POJO)
                                            .constructor(Slot::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SAMPLE_UTTERANCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateIntentVersionResponse::sampleUtterances))
            .setter(setter(Builder::sampleUtterances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleUtterances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Prompt> CONFIRMATION_PROMPT_FIELD = SdkField.<Prompt> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateIntentVersionResponse::confirmationPrompt)).setter(setter(Builder::confirmationPrompt))
            .constructor(Prompt::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confirmationPrompt").build())
            .build();

    private static final SdkField<Statement> REJECTION_STATEMENT_FIELD = SdkField.<Statement> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateIntentVersionResponse::rejectionStatement)).setter(setter(Builder::rejectionStatement))
            .constructor(Statement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rejectionStatement").build())
            .build();

    private static final SdkField<FollowUpPrompt> FOLLOW_UP_PROMPT_FIELD = SdkField
            .<FollowUpPrompt> builder(MarshallingType.SDK_POJO).getter(getter(CreateIntentVersionResponse::followUpPrompt))
            .setter(setter(Builder::followUpPrompt)).constructor(FollowUpPrompt::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("followUpPrompt").build()).build();

    private static final SdkField<Statement> CONCLUSION_STATEMENT_FIELD = SdkField.<Statement> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateIntentVersionResponse::conclusionStatement)).setter(setter(Builder::conclusionStatement))
            .constructor(Statement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conclusionStatement").build())
            .build();

    private static final SdkField<CodeHook> DIALOG_CODE_HOOK_FIELD = SdkField.<CodeHook> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateIntentVersionResponse::dialogCodeHook)).setter(setter(Builder::dialogCodeHook))
            .constructor(CodeHook::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialogCodeHook").build()).build();

    private static final SdkField<FulfillmentActivity> FULFILLMENT_ACTIVITY_FIELD = SdkField
            .<FulfillmentActivity> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateIntentVersionResponse::fulfillmentActivity)).setter(setter(Builder::fulfillmentActivity))
            .constructor(FulfillmentActivity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fulfillmentActivity").build())
            .build();

    private static final SdkField<String> PARENT_INTENT_SIGNATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateIntentVersionResponse::parentIntentSignature)).setter(setter(Builder::parentIntentSignature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentIntentSignature").build())
            .build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(CreateIntentVersionResponse::lastUpdatedDate)).setter(setter(Builder::lastUpdatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDate").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(CreateIntentVersionResponse::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateIntentVersionResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> CHECKSUM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateIntentVersionResponse::checksum)).setter(setter(Builder::checksum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checksum").build()).build();

    private static final SdkField<KendraConfiguration> KENDRA_CONFIGURATION_FIELD = SdkField
            .<KendraConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateIntentVersionResponse::kendraConfiguration)).setter(setter(Builder::kendraConfiguration))
            .constructor(KendraConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kendraConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            SLOTS_FIELD, SAMPLE_UTTERANCES_FIELD, CONFIRMATION_PROMPT_FIELD, REJECTION_STATEMENT_FIELD, FOLLOW_UP_PROMPT_FIELD,
            CONCLUSION_STATEMENT_FIELD, DIALOG_CODE_HOOK_FIELD, FULFILLMENT_ACTIVITY_FIELD, PARENT_INTENT_SIGNATURE_FIELD,
            LAST_UPDATED_DATE_FIELD, CREATED_DATE_FIELD, VERSION_FIELD, CHECKSUM_FIELD, KENDRA_CONFIGURATION_FIELD));

    private final String name;

    private final String description;

    private final List<Slot> slots;

    private final List<String> sampleUtterances;

    private final Prompt confirmationPrompt;

    private final Statement rejectionStatement;

    private final FollowUpPrompt followUpPrompt;

    private final Statement conclusionStatement;

    private final CodeHook dialogCodeHook;

    private final FulfillmentActivity fulfillmentActivity;

    private final String parentIntentSignature;

    private final Instant lastUpdatedDate;

    private final Instant createdDate;

    private final String version;

    private final String checksum;

    private final KendraConfiguration kendraConfiguration;

    private CreateIntentVersionResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.slots = builder.slots;
        this.sampleUtterances = builder.sampleUtterances;
        this.confirmationPrompt = builder.confirmationPrompt;
        this.rejectionStatement = builder.rejectionStatement;
        this.followUpPrompt = builder.followUpPrompt;
        this.conclusionStatement = builder.conclusionStatement;
        this.dialogCodeHook = builder.dialogCodeHook;
        this.fulfillmentActivity = builder.fulfillmentActivity;
        this.parentIntentSignature = builder.parentIntentSignature;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.createdDate = builder.createdDate;
        this.version = builder.version;
        this.checksum = builder.checksum;
        this.kendraConfiguration = builder.kendraConfiguration;
    }

    /**
     * <p>
     * The name of the intent.
     * </p>
     * 
     * @return The name of the intent.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A description of the intent.
     * </p>
     * 
     * @return A description of the intent.
     */
    public String description() {
        return description;
    }

    /**
     * Returns true if the Slots property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSlots() {
        return slots != null && !(slots instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of slot types that defines the information required to fulfill the intent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSlots()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of slot types that defines the information required to fulfill the intent.
     */
    public List<Slot> slots() {
        return slots;
    }

    /**
     * Returns true if the SampleUtterances property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSampleUtterances() {
        return sampleUtterances != null && !(sampleUtterances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of sample utterances configured for the intent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSampleUtterances()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of sample utterances configured for the intent.
     */
    public List<String> sampleUtterances() {
        return sampleUtterances;
    }

    /**
     * <p>
     * If defined, the prompt that Amazon Lex uses to confirm the user's intent before fulfilling it.
     * </p>
     * 
     * @return If defined, the prompt that Amazon Lex uses to confirm the user's intent before fulfilling it.
     */
    public Prompt confirmationPrompt() {
        return confirmationPrompt;
    }

    /**
     * <p>
     * If the user answers "no" to the question defined in <code>confirmationPrompt</code>, Amazon Lex responds with
     * this statement to acknowledge that the intent was canceled.
     * </p>
     * 
     * @return If the user answers "no" to the question defined in <code>confirmationPrompt</code>, Amazon Lex responds
     *         with this statement to acknowledge that the intent was canceled.
     */
    public Statement rejectionStatement() {
        return rejectionStatement;
    }

    /**
     * <p>
     * If defined, Amazon Lex uses this prompt to solicit additional user activity after the intent is fulfilled.
     * </p>
     * 
     * @return If defined, Amazon Lex uses this prompt to solicit additional user activity after the intent is
     *         fulfilled.
     */
    public FollowUpPrompt followUpPrompt() {
        return followUpPrompt;
    }

    /**
     * <p>
     * After the Lambda function specified in the <code>fulfillmentActivity</code> field fulfills the intent, Amazon Lex
     * conveys this statement to the user.
     * </p>
     * 
     * @return After the Lambda function specified in the <code>fulfillmentActivity</code> field fulfills the intent,
     *         Amazon Lex conveys this statement to the user.
     */
    public Statement conclusionStatement() {
        return conclusionStatement;
    }

    /**
     * <p>
     * If defined, Amazon Lex invokes this Lambda function for each user input.
     * </p>
     * 
     * @return If defined, Amazon Lex invokes this Lambda function for each user input.
     */
    public CodeHook dialogCodeHook() {
        return dialogCodeHook;
    }

    /**
     * <p>
     * Describes how the intent is fulfilled.
     * </p>
     * 
     * @return Describes how the intent is fulfilled.
     */
    public FulfillmentActivity fulfillmentActivity() {
        return fulfillmentActivity;
    }

    /**
     * <p>
     * A unique identifier for a built-in intent.
     * </p>
     * 
     * @return A unique identifier for a built-in intent.
     */
    public String parentIntentSignature() {
        return parentIntentSignature;
    }

    /**
     * <p>
     * The date that the intent was updated.
     * </p>
     * 
     * @return The date that the intent was updated.
     */
    public Instant lastUpdatedDate() {
        return lastUpdatedDate;
    }

    /**
     * <p>
     * The date that the intent was created.
     * </p>
     * 
     * @return The date that the intent was created.
     */
    public Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The version number assigned to the new version of the intent.
     * </p>
     * 
     * @return The version number assigned to the new version of the intent.
     */
    public String version() {
        return version;
    }

    /**
     * <p>
     * Checksum of the intent version created.
     * </p>
     * 
     * @return Checksum of the intent version created.
     */
    public String checksum() {
        return checksum;
    }

    /**
     * <p>
     * Configuration information, if any, for connectin an Amazon Kendra index with the
     * <code>AMAZON.KendraSearchIntent</code> intent.
     * </p>
     * 
     * @return Configuration information, if any, for connectin an Amazon Kendra index with the
     *         <code>AMAZON.KendraSearchIntent</code> intent.
     */
    public KendraConfiguration kendraConfiguration() {
        return kendraConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(slots());
        hashCode = 31 * hashCode + Objects.hashCode(sampleUtterances());
        hashCode = 31 * hashCode + Objects.hashCode(confirmationPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(rejectionStatement());
        hashCode = 31 * hashCode + Objects.hashCode(followUpPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(conclusionStatement());
        hashCode = 31 * hashCode + Objects.hashCode(dialogCodeHook());
        hashCode = 31 * hashCode + Objects.hashCode(fulfillmentActivity());
        hashCode = 31 * hashCode + Objects.hashCode(parentIntentSignature());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(checksum());
        hashCode = 31 * hashCode + Objects.hashCode(kendraConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIntentVersionResponse)) {
            return false;
        }
        CreateIntentVersionResponse other = (CreateIntentVersionResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(slots(), other.slots()) && Objects.equals(sampleUtterances(), other.sampleUtterances())
                && Objects.equals(confirmationPrompt(), other.confirmationPrompt())
                && Objects.equals(rejectionStatement(), other.rejectionStatement())
                && Objects.equals(followUpPrompt(), other.followUpPrompt())
                && Objects.equals(conclusionStatement(), other.conclusionStatement())
                && Objects.equals(dialogCodeHook(), other.dialogCodeHook())
                && Objects.equals(fulfillmentActivity(), other.fulfillmentActivity())
                && Objects.equals(parentIntentSignature(), other.parentIntentSignature())
                && Objects.equals(lastUpdatedDate(), other.lastUpdatedDate())
                && Objects.equals(createdDate(), other.createdDate()) && Objects.equals(version(), other.version())
                && Objects.equals(checksum(), other.checksum())
                && Objects.equals(kendraConfiguration(), other.kendraConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateIntentVersionResponse").add("Name", name()).add("Description", description())
                .add("Slots", slots()).add("SampleUtterances", sampleUtterances())
                .add("ConfirmationPrompt", confirmationPrompt()).add("RejectionStatement", rejectionStatement())
                .add("FollowUpPrompt", followUpPrompt()).add("ConclusionStatement", conclusionStatement())
                .add("DialogCodeHook", dialogCodeHook()).add("FulfillmentActivity", fulfillmentActivity())
                .add("ParentIntentSignature", parentIntentSignature()).add("LastUpdatedDate", lastUpdatedDate())
                .add("CreatedDate", createdDate()).add("Version", version()).add("Checksum", checksum())
                .add("KendraConfiguration", kendraConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "slots":
            return Optional.ofNullable(clazz.cast(slots()));
        case "sampleUtterances":
            return Optional.ofNullable(clazz.cast(sampleUtterances()));
        case "confirmationPrompt":
            return Optional.ofNullable(clazz.cast(confirmationPrompt()));
        case "rejectionStatement":
            return Optional.ofNullable(clazz.cast(rejectionStatement()));
        case "followUpPrompt":
            return Optional.ofNullable(clazz.cast(followUpPrompt()));
        case "conclusionStatement":
            return Optional.ofNullable(clazz.cast(conclusionStatement()));
        case "dialogCodeHook":
            return Optional.ofNullable(clazz.cast(dialogCodeHook()));
        case "fulfillmentActivity":
            return Optional.ofNullable(clazz.cast(fulfillmentActivity()));
        case "parentIntentSignature":
            return Optional.ofNullable(clazz.cast(parentIntentSignature()));
        case "lastUpdatedDate":
            return Optional.ofNullable(clazz.cast(lastUpdatedDate()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "checksum":
            return Optional.ofNullable(clazz.cast(checksum()));
        case "kendraConfiguration":
            return Optional.ofNullable(clazz.cast(kendraConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateIntentVersionResponse, T> g) {
        return obj -> g.apply((CreateIntentVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelBuildingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateIntentVersionResponse> {
        /**
         * <p>
         * The name of the intent.
         * </p>
         * 
         * @param name
         *        The name of the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the intent.
         * </p>
         * 
         * @param description
         *        A description of the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An array of slot types that defines the information required to fulfill the intent.
         * </p>
         * 
         * @param slots
         *        An array of slot types that defines the information required to fulfill the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slots(Collection<Slot> slots);

        /**
         * <p>
         * An array of slot types that defines the information required to fulfill the intent.
         * </p>
         * 
         * @param slots
         *        An array of slot types that defines the information required to fulfill the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slots(Slot... slots);

        /**
         * <p>
         * An array of slot types that defines the information required to fulfill the intent.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Slot>.Builder} avoiding the need to create
         * one manually via {@link List<Slot>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Slot>.Builder#build()} is called immediately and its result
         * is passed to {@link #slots(List<Slot>)}.
         * 
         * @param slots
         *        a consumer that will call methods on {@link List<Slot>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slots(List<Slot>)
         */
        Builder slots(Consumer<Slot.Builder>... slots);

        /**
         * <p>
         * An array of sample utterances configured for the intent.
         * </p>
         * 
         * @param sampleUtterances
         *        An array of sample utterances configured for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleUtterances(Collection<String> sampleUtterances);

        /**
         * <p>
         * An array of sample utterances configured for the intent.
         * </p>
         * 
         * @param sampleUtterances
         *        An array of sample utterances configured for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleUtterances(String... sampleUtterances);

        /**
         * <p>
         * If defined, the prompt that Amazon Lex uses to confirm the user's intent before fulfilling it.
         * </p>
         * 
         * @param confirmationPrompt
         *        If defined, the prompt that Amazon Lex uses to confirm the user's intent before fulfilling it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confirmationPrompt(Prompt confirmationPrompt);

        /**
         * <p>
         * If defined, the prompt that Amazon Lex uses to confirm the user's intent before fulfilling it.
         * </p>
         * This is a convenience that creates an instance of the {@link Prompt.Builder} avoiding the need to create one
         * manually via {@link Prompt#builder()}.
         *
         * When the {@link Consumer} completes, {@link Prompt.Builder#build()} is called immediately and its result is
         * passed to {@link #confirmationPrompt(Prompt)}.
         * 
         * @param confirmationPrompt
         *        a consumer that will call methods on {@link Prompt.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #confirmationPrompt(Prompt)
         */
        default Builder confirmationPrompt(Consumer<Prompt.Builder> confirmationPrompt) {
            return confirmationPrompt(Prompt.builder().applyMutation(confirmationPrompt).build());
        }

        /**
         * <p>
         * If the user answers "no" to the question defined in <code>confirmationPrompt</code>, Amazon Lex responds with
         * this statement to acknowledge that the intent was canceled.
         * </p>
         * 
         * @param rejectionStatement
         *        If the user answers "no" to the question defined in <code>confirmationPrompt</code>, Amazon Lex
         *        responds with this statement to acknowledge that the intent was canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectionStatement(Statement rejectionStatement);

        /**
         * <p>
         * If the user answers "no" to the question defined in <code>confirmationPrompt</code>, Amazon Lex responds with
         * this statement to acknowledge that the intent was canceled.
         * </p>
         * This is a convenience that creates an instance of the {@link Statement.Builder} avoiding the need to create
         * one manually via {@link Statement#builder()}.
         *
         * When the {@link Consumer} completes, {@link Statement.Builder#build()} is called immediately and its result
         * is passed to {@link #rejectionStatement(Statement)}.
         * 
         * @param rejectionStatement
         *        a consumer that will call methods on {@link Statement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rejectionStatement(Statement)
         */
        default Builder rejectionStatement(Consumer<Statement.Builder> rejectionStatement) {
            return rejectionStatement(Statement.builder().applyMutation(rejectionStatement).build());
        }

        /**
         * <p>
         * If defined, Amazon Lex uses this prompt to solicit additional user activity after the intent is fulfilled.
         * </p>
         * 
         * @param followUpPrompt
         *        If defined, Amazon Lex uses this prompt to solicit additional user activity after the intent is
         *        fulfilled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder followUpPrompt(FollowUpPrompt followUpPrompt);

        /**
         * <p>
         * If defined, Amazon Lex uses this prompt to solicit additional user activity after the intent is fulfilled.
         * </p>
         * This is a convenience that creates an instance of the {@link FollowUpPrompt.Builder} avoiding the need to
         * create one manually via {@link FollowUpPrompt#builder()}.
         *
         * When the {@link Consumer} completes, {@link FollowUpPrompt.Builder#build()} is called immediately and its
         * result is passed to {@link #followUpPrompt(FollowUpPrompt)}.
         * 
         * @param followUpPrompt
         *        a consumer that will call methods on {@link FollowUpPrompt.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #followUpPrompt(FollowUpPrompt)
         */
        default Builder followUpPrompt(Consumer<FollowUpPrompt.Builder> followUpPrompt) {
            return followUpPrompt(FollowUpPrompt.builder().applyMutation(followUpPrompt).build());
        }

        /**
         * <p>
         * After the Lambda function specified in the <code>fulfillmentActivity</code> field fulfills the intent, Amazon
         * Lex conveys this statement to the user.
         * </p>
         * 
         * @param conclusionStatement
         *        After the Lambda function specified in the <code>fulfillmentActivity</code> field fulfills the intent,
         *        Amazon Lex conveys this statement to the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conclusionStatement(Statement conclusionStatement);

        /**
         * <p>
         * After the Lambda function specified in the <code>fulfillmentActivity</code> field fulfills the intent, Amazon
         * Lex conveys this statement to the user.
         * </p>
         * This is a convenience that creates an instance of the {@link Statement.Builder} avoiding the need to create
         * one manually via {@link Statement#builder()}.
         *
         * When the {@link Consumer} completes, {@link Statement.Builder#build()} is called immediately and its result
         * is passed to {@link #conclusionStatement(Statement)}.
         * 
         * @param conclusionStatement
         *        a consumer that will call methods on {@link Statement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conclusionStatement(Statement)
         */
        default Builder conclusionStatement(Consumer<Statement.Builder> conclusionStatement) {
            return conclusionStatement(Statement.builder().applyMutation(conclusionStatement).build());
        }

        /**
         * <p>
         * If defined, Amazon Lex invokes this Lambda function for each user input.
         * </p>
         * 
         * @param dialogCodeHook
         *        If defined, Amazon Lex invokes this Lambda function for each user input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dialogCodeHook(CodeHook dialogCodeHook);

        /**
         * <p>
         * If defined, Amazon Lex invokes this Lambda function for each user input.
         * </p>
         * This is a convenience that creates an instance of the {@link CodeHook.Builder} avoiding the need to create
         * one manually via {@link CodeHook#builder()}.
         *
         * When the {@link Consumer} completes, {@link CodeHook.Builder#build()} is called immediately and its result is
         * passed to {@link #dialogCodeHook(CodeHook)}.
         * 
         * @param dialogCodeHook
         *        a consumer that will call methods on {@link CodeHook.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dialogCodeHook(CodeHook)
         */
        default Builder dialogCodeHook(Consumer<CodeHook.Builder> dialogCodeHook) {
            return dialogCodeHook(CodeHook.builder().applyMutation(dialogCodeHook).build());
        }

        /**
         * <p>
         * Describes how the intent is fulfilled.
         * </p>
         * 
         * @param fulfillmentActivity
         *        Describes how the intent is fulfilled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfillmentActivity(FulfillmentActivity fulfillmentActivity);

        /**
         * <p>
         * Describes how the intent is fulfilled.
         * </p>
         * This is a convenience that creates an instance of the {@link FulfillmentActivity.Builder} avoiding the need
         * to create one manually via {@link FulfillmentActivity#builder()}.
         *
         * When the {@link Consumer} completes, {@link FulfillmentActivity.Builder#build()} is called immediately and
         * its result is passed to {@link #fulfillmentActivity(FulfillmentActivity)}.
         * 
         * @param fulfillmentActivity
         *        a consumer that will call methods on {@link FulfillmentActivity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fulfillmentActivity(FulfillmentActivity)
         */
        default Builder fulfillmentActivity(Consumer<FulfillmentActivity.Builder> fulfillmentActivity) {
            return fulfillmentActivity(FulfillmentActivity.builder().applyMutation(fulfillmentActivity).build());
        }

        /**
         * <p>
         * A unique identifier for a built-in intent.
         * </p>
         * 
         * @param parentIntentSignature
         *        A unique identifier for a built-in intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentIntentSignature(String parentIntentSignature);

        /**
         * <p>
         * The date that the intent was updated.
         * </p>
         * 
         * @param lastUpdatedDate
         *        The date that the intent was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(Instant lastUpdatedDate);

        /**
         * <p>
         * The date that the intent was created.
         * </p>
         * 
         * @param createdDate
         *        The date that the intent was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The version number assigned to the new version of the intent.
         * </p>
         * 
         * @param version
         *        The version number assigned to the new version of the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * Checksum of the intent version created.
         * </p>
         * 
         * @param checksum
         *        Checksum of the intent version created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checksum(String checksum);

        /**
         * <p>
         * Configuration information, if any, for connectin an Amazon Kendra index with the
         * <code>AMAZON.KendraSearchIntent</code> intent.
         * </p>
         * 
         * @param kendraConfiguration
         *        Configuration information, if any, for connectin an Amazon Kendra index with the
         *        <code>AMAZON.KendraSearchIntent</code> intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kendraConfiguration(KendraConfiguration kendraConfiguration);

        /**
         * <p>
         * Configuration information, if any, for connectin an Amazon Kendra index with the
         * <code>AMAZON.KendraSearchIntent</code> intent.
         * </p>
         * This is a convenience that creates an instance of the {@link KendraConfiguration.Builder} avoiding the need
         * to create one manually via {@link KendraConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link KendraConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #kendraConfiguration(KendraConfiguration)}.
         * 
         * @param kendraConfiguration
         *        a consumer that will call methods on {@link KendraConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kendraConfiguration(KendraConfiguration)
         */
        default Builder kendraConfiguration(Consumer<KendraConfiguration.Builder> kendraConfiguration) {
            return kendraConfiguration(KendraConfiguration.builder().applyMutation(kendraConfiguration).build());
        }
    }

    static final class BuilderImpl extends LexModelBuildingResponse.BuilderImpl implements Builder {
        private String name;

        private String description;

        private List<Slot> slots = DefaultSdkAutoConstructList.getInstance();

        private List<String> sampleUtterances = DefaultSdkAutoConstructList.getInstance();

        private Prompt confirmationPrompt;

        private Statement rejectionStatement;

        private FollowUpPrompt followUpPrompt;

        private Statement conclusionStatement;

        private CodeHook dialogCodeHook;

        private FulfillmentActivity fulfillmentActivity;

        private String parentIntentSignature;

        private Instant lastUpdatedDate;

        private Instant createdDate;

        private String version;

        private String checksum;

        private KendraConfiguration kendraConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIntentVersionResponse model) {
            super(model);
            name(model.name);
            description(model.description);
            slots(model.slots);
            sampleUtterances(model.sampleUtterances);
            confirmationPrompt(model.confirmationPrompt);
            rejectionStatement(model.rejectionStatement);
            followUpPrompt(model.followUpPrompt);
            conclusionStatement(model.conclusionStatement);
            dialogCodeHook(model.dialogCodeHook);
            fulfillmentActivity(model.fulfillmentActivity);
            parentIntentSignature(model.parentIntentSignature);
            lastUpdatedDate(model.lastUpdatedDate);
            createdDate(model.createdDate);
            version(model.version);
            checksum(model.checksum);
            kendraConfiguration(model.kendraConfiguration);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Slot.Builder> getSlots() {
            return slots != null ? slots.stream().map(Slot::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder slots(Collection<Slot> slots) {
            this.slots = SlotListCopier.copy(slots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slots(Slot... slots) {
            slots(Arrays.asList(slots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slots(Consumer<Slot.Builder>... slots) {
            slots(Stream.of(slots).map(c -> Slot.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSlots(Collection<Slot.BuilderImpl> slots) {
            this.slots = SlotListCopier.copyFromBuilder(slots);
        }

        public final Collection<String> getSampleUtterances() {
            return sampleUtterances;
        }

        @Override
        public final Builder sampleUtterances(Collection<String> sampleUtterances) {
            this.sampleUtterances = IntentUtteranceListCopier.copy(sampleUtterances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleUtterances(String... sampleUtterances) {
            sampleUtterances(Arrays.asList(sampleUtterances));
            return this;
        }

        public final void setSampleUtterances(Collection<String> sampleUtterances) {
            this.sampleUtterances = IntentUtteranceListCopier.copy(sampleUtterances);
        }

        public final Prompt.Builder getConfirmationPrompt() {
            return confirmationPrompt != null ? confirmationPrompt.toBuilder() : null;
        }

        @Override
        public final Builder confirmationPrompt(Prompt confirmationPrompt) {
            this.confirmationPrompt = confirmationPrompt;
            return this;
        }

        public final void setConfirmationPrompt(Prompt.BuilderImpl confirmationPrompt) {
            this.confirmationPrompt = confirmationPrompt != null ? confirmationPrompt.build() : null;
        }

        public final Statement.Builder getRejectionStatement() {
            return rejectionStatement != null ? rejectionStatement.toBuilder() : null;
        }

        @Override
        public final Builder rejectionStatement(Statement rejectionStatement) {
            this.rejectionStatement = rejectionStatement;
            return this;
        }

        public final void setRejectionStatement(Statement.BuilderImpl rejectionStatement) {
            this.rejectionStatement = rejectionStatement != null ? rejectionStatement.build() : null;
        }

        public final FollowUpPrompt.Builder getFollowUpPrompt() {
            return followUpPrompt != null ? followUpPrompt.toBuilder() : null;
        }

        @Override
        public final Builder followUpPrompt(FollowUpPrompt followUpPrompt) {
            this.followUpPrompt = followUpPrompt;
            return this;
        }

        public final void setFollowUpPrompt(FollowUpPrompt.BuilderImpl followUpPrompt) {
            this.followUpPrompt = followUpPrompt != null ? followUpPrompt.build() : null;
        }

        public final Statement.Builder getConclusionStatement() {
            return conclusionStatement != null ? conclusionStatement.toBuilder() : null;
        }

        @Override
        public final Builder conclusionStatement(Statement conclusionStatement) {
            this.conclusionStatement = conclusionStatement;
            return this;
        }

        public final void setConclusionStatement(Statement.BuilderImpl conclusionStatement) {
            this.conclusionStatement = conclusionStatement != null ? conclusionStatement.build() : null;
        }

        public final CodeHook.Builder getDialogCodeHook() {
            return dialogCodeHook != null ? dialogCodeHook.toBuilder() : null;
        }

        @Override
        public final Builder dialogCodeHook(CodeHook dialogCodeHook) {
            this.dialogCodeHook = dialogCodeHook;
            return this;
        }

        public final void setDialogCodeHook(CodeHook.BuilderImpl dialogCodeHook) {
            this.dialogCodeHook = dialogCodeHook != null ? dialogCodeHook.build() : null;
        }

        public final FulfillmentActivity.Builder getFulfillmentActivity() {
            return fulfillmentActivity != null ? fulfillmentActivity.toBuilder() : null;
        }

        @Override
        public final Builder fulfillmentActivity(FulfillmentActivity fulfillmentActivity) {
            this.fulfillmentActivity = fulfillmentActivity;
            return this;
        }

        public final void setFulfillmentActivity(FulfillmentActivity.BuilderImpl fulfillmentActivity) {
            this.fulfillmentActivity = fulfillmentActivity != null ? fulfillmentActivity.build() : null;
        }

        public final String getParentIntentSignature() {
            return parentIntentSignature;
        }

        @Override
        public final Builder parentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
            return this;
        }

        public final void setParentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
        }

        public final Instant getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getChecksum() {
            return checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public final KendraConfiguration.Builder getKendraConfiguration() {
            return kendraConfiguration != null ? kendraConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder kendraConfiguration(KendraConfiguration kendraConfiguration) {
            this.kendraConfiguration = kendraConfiguration;
            return this;
        }

        public final void setKendraConfiguration(KendraConfiguration.BuilderImpl kendraConfiguration) {
            this.kendraConfiguration = kendraConfiguration != null ? kendraConfiguration.build() : null;
        }

        @Override
        public CreateIntentVersionResponse build() {
            return new CreateIntentVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
