/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a Lambda function that verifies requests to a bot or fulfills the user's request to a bot..
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeHook implements SdkPojo, Serializable, ToCopyableBuilder<CodeHook.Builder, CodeHook> {
    private static final SdkField<String> URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CodeHook::uri)).setter(setter(Builder::uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uri").build()).build();

    private static final SdkField<String> MESSAGE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CodeHook::messageVersion)).setter(setter(Builder::messageVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URI_FIELD,
            MESSAGE_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String uri;

    private final String messageVersion;

    private CodeHook(BuilderImpl builder) {
        this.uri = builder.uri;
        this.messageVersion = builder.messageVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Lambda function.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Lambda function.
     */
    public String uri() {
        return uri;
    }

    /**
     * <p>
     * The version of the request-response that you want Amazon Lex to use to invoke your Lambda function. For more
     * information, see <a>using-lambda</a>.
     * </p>
     * 
     * @return The version of the request-response that you want Amazon Lex to use to invoke your Lambda function. For
     *         more information, see <a>using-lambda</a>.
     */
    public String messageVersion() {
        return messageVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(uri());
        hashCode = 31 * hashCode + Objects.hashCode(messageVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeHook)) {
            return false;
        }
        CodeHook other = (CodeHook) obj;
        return Objects.equals(uri(), other.uri()) && Objects.equals(messageVersion(), other.messageVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CodeHook").add("Uri", uri()).add("MessageVersion", messageVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "uri":
            return Optional.ofNullable(clazz.cast(uri()));
        case "messageVersion":
            return Optional.ofNullable(clazz.cast(messageVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CodeHook, T> g) {
        return obj -> g.apply((CodeHook) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeHook> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Lambda function.
         * </p>
         * 
         * @param uri
         *        The Amazon Resource Name (ARN) of the Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uri(String uri);

        /**
         * <p>
         * The version of the request-response that you want Amazon Lex to use to invoke your Lambda function. For more
         * information, see <a>using-lambda</a>.
         * </p>
         * 
         * @param messageVersion
         *        The version of the request-response that you want Amazon Lex to use to invoke your Lambda function.
         *        For more information, see <a>using-lambda</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageVersion(String messageVersion);
    }

    static final class BuilderImpl implements Builder {
        private String uri;

        private String messageVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeHook model) {
            uri(model.uri);
            messageVersion(model.messageVersion);
        }

        public final String getUri() {
            return uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        public final String getMessageVersion() {
            return messageVersion;
        }

        @Override
        public final Builder messageVersion(String messageVersion) {
            this.messageVersion = messageVersion;
            return this;
        }

        public final void setMessageVersion(String messageVersion) {
            this.messageVersion = messageVersion;
        }

        @Override
        public CodeHook build() {
            return new CodeHook(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
