/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelbuilding.model.EnumerationValue;
import software.amazon.awssdk.services.lexmodelbuilding.model.EnumerationValuesCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.SlotTypeConfiguration;
import software.amazon.awssdk.services.lexmodelbuilding.model.SlotTypeConfigurationsCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.SlotValueSelectionStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSlotTypeResponse
extends LexModelBuildingResponse
implements ToCopyableBuilder<Builder, GetSlotTypeResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetSlotTypeResponse.getter(GetSlotTypeResponse::name)).setter(GetSlotTypeResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetSlotTypeResponse.getter(GetSlotTypeResponse::description)).setter(GetSlotTypeResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<EnumerationValue>> ENUMERATION_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetSlotTypeResponse.getter(GetSlotTypeResponse::enumerationValues)).setter(GetSlotTypeResponse.setter(Builder::enumerationValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enumerationValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnumerationValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetSlotTypeResponse.getter(GetSlotTypeResponse::lastUpdatedDate)).setter(GetSlotTypeResponse.setter(Builder::lastUpdatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDate").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetSlotTypeResponse.getter(GetSlotTypeResponse::createdDate)).setter(GetSlotTypeResponse.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetSlotTypeResponse.getter(GetSlotTypeResponse::version)).setter(GetSlotTypeResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> CHECKSUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetSlotTypeResponse.getter(GetSlotTypeResponse::checksum)).setter(GetSlotTypeResponse.setter(Builder::checksum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checksum").build()}).build();
    private static final SdkField<String> VALUE_SELECTION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetSlotTypeResponse.getter(GetSlotTypeResponse::valueSelectionStrategyAsString)).setter(GetSlotTypeResponse.setter(Builder::valueSelectionStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueSelectionStrategy").build()}).build();
    private static final SdkField<String> PARENT_SLOT_TYPE_SIGNATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetSlotTypeResponse.getter(GetSlotTypeResponse::parentSlotTypeSignature)).setter(GetSlotTypeResponse.setter(Builder::parentSlotTypeSignature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentSlotTypeSignature").build()}).build();
    private static final SdkField<List<SlotTypeConfiguration>> SLOT_TYPE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetSlotTypeResponse.getter(GetSlotTypeResponse::slotTypeConfigurations)).setter(GetSlotTypeResponse.setter(Builder::slotTypeConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypeConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SlotTypeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, ENUMERATION_VALUES_FIELD, LAST_UPDATED_DATE_FIELD, CREATED_DATE_FIELD, VERSION_FIELD, CHECKSUM_FIELD, VALUE_SELECTION_STRATEGY_FIELD, PARENT_SLOT_TYPE_SIGNATURE_FIELD, SLOT_TYPE_CONFIGURATIONS_FIELD));
    private final String name;
    private final String description;
    private final List<EnumerationValue> enumerationValues;
    private final Instant lastUpdatedDate;
    private final Instant createdDate;
    private final String version;
    private final String checksum;
    private final String valueSelectionStrategy;
    private final String parentSlotTypeSignature;
    private final List<SlotTypeConfiguration> slotTypeConfigurations;

    private GetSlotTypeResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.enumerationValues = builder.enumerationValues;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.createdDate = builder.createdDate;
        this.version = builder.version;
        this.checksum = builder.checksum;
        this.valueSelectionStrategy = builder.valueSelectionStrategy;
        this.parentSlotTypeSignature = builder.parentSlotTypeSignature;
        this.slotTypeConfigurations = builder.slotTypeConfigurations;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public boolean hasEnumerationValues() {
        return this.enumerationValues != null && !(this.enumerationValues instanceof SdkAutoConstructList);
    }

    public List<EnumerationValue> enumerationValues() {
        return this.enumerationValues;
    }

    public Instant lastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public String version() {
        return this.version;
    }

    public String checksum() {
        return this.checksum;
    }

    public SlotValueSelectionStrategy valueSelectionStrategy() {
        return SlotValueSelectionStrategy.fromValue(this.valueSelectionStrategy);
    }

    public String valueSelectionStrategyAsString() {
        return this.valueSelectionStrategy;
    }

    public String parentSlotTypeSignature() {
        return this.parentSlotTypeSignature;
    }

    public boolean hasSlotTypeConfigurations() {
        return this.slotTypeConfigurations != null && !(this.slotTypeConfigurations instanceof SdkAutoConstructList);
    }

    public List<SlotTypeConfiguration> slotTypeConfigurations() {
        return this.slotTypeConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.enumerationValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueSelectionStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentSlotTypeSignature());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotTypeConfigurations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSlotTypeResponse)) {
            return false;
        }
        GetSlotTypeResponse other = (GetSlotTypeResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.enumerationValues(), other.enumerationValues()) && Objects.equals(this.lastUpdatedDate(), other.lastUpdatedDate()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.checksum(), other.checksum()) && Objects.equals(this.valueSelectionStrategyAsString(), other.valueSelectionStrategyAsString()) && Objects.equals(this.parentSlotTypeSignature(), other.parentSlotTypeSignature()) && Objects.equals(this.slotTypeConfigurations(), other.slotTypeConfigurations());
    }

    public String toString() {
        return ToString.builder((String)"GetSlotTypeResponse").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("EnumerationValues", this.enumerationValues()).add("LastUpdatedDate", (Object)this.lastUpdatedDate()).add("CreatedDate", (Object)this.createdDate()).add("Version", (Object)this.version()).add("Checksum", (Object)this.checksum()).add("ValueSelectionStrategy", (Object)this.valueSelectionStrategyAsString()).add("ParentSlotTypeSignature", (Object)this.parentSlotTypeSignature()).add("SlotTypeConfigurations", this.slotTypeConfigurations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "enumerationValues": {
                return Optional.ofNullable(clazz.cast(this.enumerationValues()));
            }
            case "lastUpdatedDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDate()));
            }
            case "createdDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "checksum": {
                return Optional.ofNullable(clazz.cast(this.checksum()));
            }
            case "valueSelectionStrategy": {
                return Optional.ofNullable(clazz.cast(this.valueSelectionStrategyAsString()));
            }
            case "parentSlotTypeSignature": {
                return Optional.ofNullable(clazz.cast(this.parentSlotTypeSignature()));
            }
            case "slotTypeConfigurations": {
                return Optional.ofNullable(clazz.cast(this.slotTypeConfigurations()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSlotTypeResponse, T> g) {
        return obj -> g.apply((GetSlotTypeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelBuildingResponse.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<EnumerationValue> enumerationValues = DefaultSdkAutoConstructList.getInstance();
        private Instant lastUpdatedDate;
        private Instant createdDate;
        private String version;
        private String checksum;
        private String valueSelectionStrategy;
        private String parentSlotTypeSignature;
        private List<SlotTypeConfiguration> slotTypeConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSlotTypeResponse model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.enumerationValues(model.enumerationValues);
            this.lastUpdatedDate(model.lastUpdatedDate);
            this.createdDate(model.createdDate);
            this.version(model.version);
            this.checksum(model.checksum);
            this.valueSelectionStrategy(model.valueSelectionStrategy);
            this.parentSlotTypeSignature(model.parentSlotTypeSignature);
            this.slotTypeConfigurations(model.slotTypeConfigurations);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<EnumerationValue.Builder> getEnumerationValues() {
            return this.enumerationValues != null ? (Collection)this.enumerationValues.stream().map(EnumerationValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder enumerationValues(Collection<EnumerationValue> enumerationValues) {
            this.enumerationValues = EnumerationValuesCopier.copy(enumerationValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enumerationValues(EnumerationValue ... enumerationValues) {
            this.enumerationValues(Arrays.asList(enumerationValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enumerationValues(Consumer<EnumerationValue.Builder> ... enumerationValues) {
            this.enumerationValues(Stream.of(enumerationValues).map(c -> (EnumerationValue)((EnumerationValue.Builder)EnumerationValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEnumerationValues(Collection<EnumerationValue.BuilderImpl> enumerationValues) {
            this.enumerationValues = EnumerationValuesCopier.copyFromBuilder(enumerationValues);
        }

        public final Instant getLastUpdatedDate() {
            return this.lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getChecksum() {
            return this.checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public final String getValueSelectionStrategy() {
            return this.valueSelectionStrategy;
        }

        @Override
        public final Builder valueSelectionStrategy(String valueSelectionStrategy) {
            this.valueSelectionStrategy = valueSelectionStrategy;
            return this;
        }

        @Override
        public final Builder valueSelectionStrategy(SlotValueSelectionStrategy valueSelectionStrategy) {
            this.valueSelectionStrategy(valueSelectionStrategy == null ? null : valueSelectionStrategy.toString());
            return this;
        }

        public final void setValueSelectionStrategy(String valueSelectionStrategy) {
            this.valueSelectionStrategy = valueSelectionStrategy;
        }

        public final String getParentSlotTypeSignature() {
            return this.parentSlotTypeSignature;
        }

        @Override
        public final Builder parentSlotTypeSignature(String parentSlotTypeSignature) {
            this.parentSlotTypeSignature = parentSlotTypeSignature;
            return this;
        }

        public final void setParentSlotTypeSignature(String parentSlotTypeSignature) {
            this.parentSlotTypeSignature = parentSlotTypeSignature;
        }

        public final Collection<SlotTypeConfiguration.Builder> getSlotTypeConfigurations() {
            return this.slotTypeConfigurations != null ? (Collection)this.slotTypeConfigurations.stream().map(SlotTypeConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder slotTypeConfigurations(Collection<SlotTypeConfiguration> slotTypeConfigurations) {
            this.slotTypeConfigurations = SlotTypeConfigurationsCopier.copy(slotTypeConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotTypeConfigurations(SlotTypeConfiguration ... slotTypeConfigurations) {
            this.slotTypeConfigurations(Arrays.asList(slotTypeConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotTypeConfigurations(Consumer<SlotTypeConfiguration.Builder> ... slotTypeConfigurations) {
            this.slotTypeConfigurations(Stream.of(slotTypeConfigurations).map(c -> (SlotTypeConfiguration)((SlotTypeConfiguration.Builder)SlotTypeConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSlotTypeConfigurations(Collection<SlotTypeConfiguration.BuilderImpl> slotTypeConfigurations) {
            this.slotTypeConfigurations = SlotTypeConfigurationsCopier.copyFromBuilder(slotTypeConfigurations);
        }

        @Override
        public GetSlotTypeResponse build() {
            return new GetSlotTypeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelBuildingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSlotTypeResponse> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder enumerationValues(Collection<EnumerationValue> var1);

        public Builder enumerationValues(EnumerationValue ... var1);

        public Builder enumerationValues(Consumer<EnumerationValue.Builder> ... var1);

        public Builder lastUpdatedDate(Instant var1);

        public Builder createdDate(Instant var1);

        public Builder version(String var1);

        public Builder checksum(String var1);

        public Builder valueSelectionStrategy(String var1);

        public Builder valueSelectionStrategy(SlotValueSelectionStrategy var1);

        public Builder parentSlotTypeSignature(String var1);

        public Builder slotTypeConfigurations(Collection<SlotTypeConfiguration> var1);

        public Builder slotTypeConfigurations(SlotTypeConfiguration ... var1);

        public Builder slotTypeConfigurations(Consumer<SlotTypeConfiguration.Builder> ... var1);
    }
}

