/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetImportResponse extends LexModelBuildingResponse implements
        ToCopyableBuilder<GetImportResponse.Builder, GetImportResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetImportResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(GetImportResponse::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> MERGE_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mergeStrategy").getter(getter(GetImportResponse::mergeStrategyAsString))
            .setter(setter(Builder::mergeStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeStrategy").build()).build();

    private static final SdkField<String> IMPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importId").getter(getter(GetImportResponse::importId)).setter(setter(Builder::importId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importId").build()).build();

    private static final SdkField<String> IMPORT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importStatus").getter(getter(GetImportResponse::importStatusAsString))
            .setter(setter(Builder::importStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importStatus").build()).build();

    private static final SdkField<List<String>> FAILURE_REASON_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("failureReason")
            .getter(getter(GetImportResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdDate").getter(getter(GetImportResponse::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            RESOURCE_TYPE_FIELD, MERGE_STRATEGY_FIELD, IMPORT_ID_FIELD, IMPORT_STATUS_FIELD, FAILURE_REASON_FIELD,
            CREATED_DATE_FIELD));

    private final String name;

    private final String resourceType;

    private final String mergeStrategy;

    private final String importId;

    private final String importStatus;

    private final List<String> failureReason;

    private final Instant createdDate;

    private GetImportResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.resourceType = builder.resourceType;
        this.mergeStrategy = builder.mergeStrategy;
        this.importId = builder.importId;
        this.importStatus = builder.importStatus;
        this.failureReason = builder.failureReason;
        this.createdDate = builder.createdDate;
    }

    /**
     * <p>
     * The name given to the import job.
     * </p>
     * 
     * @return The name given to the import job.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The type of resource imported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource imported.
     * @see ResourceType
     */
    public ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of resource imported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource imported.
     * @see ResourceType
     */
    public String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The action taken when there was a conflict between an existing resource and a resource in the import file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mergeStrategy}
     * will return {@link MergeStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mergeStrategyAsString}.
     * </p>
     * 
     * @return The action taken when there was a conflict between an existing resource and a resource in the import
     *         file.
     * @see MergeStrategy
     */
    public MergeStrategy mergeStrategy() {
        return MergeStrategy.fromValue(mergeStrategy);
    }

    /**
     * <p>
     * The action taken when there was a conflict between an existing resource and a resource in the import file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mergeStrategy}
     * will return {@link MergeStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mergeStrategyAsString}.
     * </p>
     * 
     * @return The action taken when there was a conflict between an existing resource and a resource in the import
     *         file.
     * @see MergeStrategy
     */
    public String mergeStrategyAsString() {
        return mergeStrategy;
    }

    /**
     * <p>
     * The identifier for the specific import job.
     * </p>
     * 
     * @return The identifier for the specific import job.
     */
    public String importId() {
        return importId;
    }

    /**
     * <p>
     * The status of the import job. If the status is <code>FAILED</code>, you can get the reason for the failure from
     * the <code>failureReason</code> field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importStatus} will
     * return {@link ImportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importStatusAsString}.
     * </p>
     * 
     * @return The status of the import job. If the status is <code>FAILED</code>, you can get the reason for the
     *         failure from the <code>failureReason</code> field.
     * @see ImportStatus
     */
    public ImportStatus importStatus() {
        return ImportStatus.fromValue(importStatus);
    }

    /**
     * <p>
     * The status of the import job. If the status is <code>FAILED</code>, you can get the reason for the failure from
     * the <code>failureReason</code> field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importStatus} will
     * return {@link ImportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importStatusAsString}.
     * </p>
     * 
     * @return The status of the import job. If the status is <code>FAILED</code>, you can get the reason for the
     *         failure from the <code>failureReason</code> field.
     * @see ImportStatus
     */
    public String importStatusAsString() {
        return importStatus;
    }

    /**
     * Returns true if the FailureReason property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFailureReason() {
        return failureReason != null && !(failureReason instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A string that describes why an import job failed to complete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFailureReason()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A string that describes why an import job failed to complete.
     */
    public List<String> failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * A timestamp for the date and time that the import job was created.
     * </p>
     * 
     * @return A timestamp for the date and time that the import job was created.
     */
    public Instant createdDate() {
        return createdDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mergeStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(importId());
        hashCode = 31 * hashCode + Objects.hashCode(importStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetImportResponse)) {
            return false;
        }
        GetImportResponse other = (GetImportResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(mergeStrategyAsString(), other.mergeStrategyAsString())
                && Objects.equals(importId(), other.importId())
                && Objects.equals(importStatusAsString(), other.importStatusAsString())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(createdDate(), other.createdDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetImportResponse").add("Name", name()).add("ResourceType", resourceTypeAsString())
                .add("MergeStrategy", mergeStrategyAsString()).add("ImportId", importId())
                .add("ImportStatus", importStatusAsString()).add("FailureReason", failureReason())
                .add("CreatedDate", createdDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "mergeStrategy":
            return Optional.ofNullable(clazz.cast(mergeStrategyAsString()));
        case "importId":
            return Optional.ofNullable(clazz.cast(importId()));
        case "importStatus":
            return Optional.ofNullable(clazz.cast(importStatusAsString()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetImportResponse, T> g) {
        return obj -> g.apply((GetImportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelBuildingResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetImportResponse> {
        /**
         * <p>
         * The name given to the import job.
         * </p>
         * 
         * @param name
         *        The name given to the import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of resource imported.
         * </p>
         * 
         * @param resourceType
         *        The type of resource imported.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resource imported.
         * </p>
         * 
         * @param resourceType
         *        The type of resource imported.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The action taken when there was a conflict between an existing resource and a resource in the import file.
         * </p>
         * 
         * @param mergeStrategy
         *        The action taken when there was a conflict between an existing resource and a resource in the import
         *        file.
         * @see MergeStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MergeStrategy
         */
        Builder mergeStrategy(String mergeStrategy);

        /**
         * <p>
         * The action taken when there was a conflict between an existing resource and a resource in the import file.
         * </p>
         * 
         * @param mergeStrategy
         *        The action taken when there was a conflict between an existing resource and a resource in the import
         *        file.
         * @see MergeStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MergeStrategy
         */
        Builder mergeStrategy(MergeStrategy mergeStrategy);

        /**
         * <p>
         * The identifier for the specific import job.
         * </p>
         * 
         * @param importId
         *        The identifier for the specific import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importId(String importId);

        /**
         * <p>
         * The status of the import job. If the status is <code>FAILED</code>, you can get the reason for the failure
         * from the <code>failureReason</code> field.
         * </p>
         * 
         * @param importStatus
         *        The status of the import job. If the status is <code>FAILED</code>, you can get the reason for the
         *        failure from the <code>failureReason</code> field.
         * @see ImportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportStatus
         */
        Builder importStatus(String importStatus);

        /**
         * <p>
         * The status of the import job. If the status is <code>FAILED</code>, you can get the reason for the failure
         * from the <code>failureReason</code> field.
         * </p>
         * 
         * @param importStatus
         *        The status of the import job. If the status is <code>FAILED</code>, you can get the reason for the
         *        failure from the <code>failureReason</code> field.
         * @see ImportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportStatus
         */
        Builder importStatus(ImportStatus importStatus);

        /**
         * <p>
         * A string that describes why an import job failed to complete.
         * </p>
         * 
         * @param failureReason
         *        A string that describes why an import job failed to complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(Collection<String> failureReason);

        /**
         * <p>
         * A string that describes why an import job failed to complete.
         * </p>
         * 
         * @param failureReason
         *        A string that describes why an import job failed to complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String... failureReason);

        /**
         * <p>
         * A timestamp for the date and time that the import job was created.
         * </p>
         * 
         * @param createdDate
         *        A timestamp for the date and time that the import job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);
    }

    static final class BuilderImpl extends LexModelBuildingResponse.BuilderImpl implements Builder {
        private String name;

        private String resourceType;

        private String mergeStrategy;

        private String importId;

        private String importStatus;

        private List<String> failureReason = DefaultSdkAutoConstructList.getInstance();

        private Instant createdDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetImportResponse model) {
            super(model);
            name(model.name);
            resourceType(model.resourceType);
            mergeStrategy(model.mergeStrategy);
            importId(model.importId);
            importStatus(model.importStatus);
            failureReason(model.failureReason);
            createdDate(model.createdDate);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getMergeStrategy() {
            return mergeStrategy;
        }

        @Override
        public final Builder mergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
            return this;
        }

        @Override
        public final Builder mergeStrategy(MergeStrategy mergeStrategy) {
            this.mergeStrategy(mergeStrategy == null ? null : mergeStrategy.toString());
            return this;
        }

        public final void setMergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
        }

        public final String getImportId() {
            return importId;
        }

        @Override
        public final Builder importId(String importId) {
            this.importId = importId;
            return this;
        }

        public final void setImportId(String importId) {
            this.importId = importId;
        }

        public final String getImportStatus() {
            return importStatus;
        }

        @Override
        public final Builder importStatus(String importStatus) {
            this.importStatus = importStatus;
            return this;
        }

        @Override
        public final Builder importStatus(ImportStatus importStatus) {
            this.importStatus(importStatus == null ? null : importStatus.toString());
            return this;
        }

        public final void setImportStatus(String importStatus) {
            this.importStatus = importStatus;
        }

        public final Collection<String> getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(Collection<String> failureReason) {
            this.failureReason = StringListCopier.copy(failureReason);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReason(String... failureReason) {
            failureReason(Arrays.asList(failureReason));
            return this;
        }

        public final void setFailureReason(Collection<String> failureReason) {
            this.failureReason = StringListCopier.copy(failureReason);
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public GetImportResponse build() {
            return new GetImportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
