/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KendraConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KendraConfiguration> {
    private static final SdkField<String> KENDRA_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kendraIndex").getter(KendraConfiguration.getter(KendraConfiguration::kendraIndex)).setter(KendraConfiguration.setter(Builder::kendraIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kendraIndex").build()}).build();
    private static final SdkField<String> QUERY_FILTER_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryFilterString").getter(KendraConfiguration.getter(KendraConfiguration::queryFilterString)).setter(KendraConfiguration.setter(Builder::queryFilterString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryFilterString").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("role").getter(KendraConfiguration.getter(KendraConfiguration::role)).setter(KendraConfiguration.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KENDRA_INDEX_FIELD, QUERY_FILTER_STRING_FIELD, ROLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String kendraIndex;
    private final String queryFilterString;
    private final String role;

    private KendraConfiguration(BuilderImpl builder) {
        this.kendraIndex = builder.kendraIndex;
        this.queryFilterString = builder.queryFilterString;
        this.role = builder.role;
    }

    public String kendraIndex() {
        return this.kendraIndex;
    }

    public String queryFilterString() {
        return this.queryFilterString;
    }

    public String role() {
        return this.role;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kendraIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryFilterString());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KendraConfiguration)) {
            return false;
        }
        KendraConfiguration other = (KendraConfiguration)obj;
        return Objects.equals(this.kendraIndex(), other.kendraIndex()) && Objects.equals(this.queryFilterString(), other.queryFilterString()) && Objects.equals(this.role(), other.role());
    }

    public String toString() {
        return ToString.builder((String)"KendraConfiguration").add("KendraIndex", (Object)this.kendraIndex()).add("QueryFilterString", (Object)this.queryFilterString()).add("Role", (Object)this.role()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "kendraIndex": {
                return Optional.ofNullable(clazz.cast(this.kendraIndex()));
            }
            case "queryFilterString": {
                return Optional.ofNullable(clazz.cast(this.queryFilterString()));
            }
            case "role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KendraConfiguration, T> g) {
        return obj -> g.apply((KendraConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String kendraIndex;
        private String queryFilterString;
        private String role;

        private BuilderImpl() {
        }

        private BuilderImpl(KendraConfiguration model) {
            this.kendraIndex(model.kendraIndex);
            this.queryFilterString(model.queryFilterString);
            this.role(model.role);
        }

        public final String getKendraIndex() {
            return this.kendraIndex;
        }

        @Override
        public final Builder kendraIndex(String kendraIndex) {
            this.kendraIndex = kendraIndex;
            return this;
        }

        public final void setKendraIndex(String kendraIndex) {
            this.kendraIndex = kendraIndex;
        }

        public final String getQueryFilterString() {
            return this.queryFilterString;
        }

        @Override
        public final Builder queryFilterString(String queryFilterString) {
            this.queryFilterString = queryFilterString;
            return this;
        }

        public final void setQueryFilterString(String queryFilterString) {
            this.queryFilterString = queryFilterString;
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public KendraConfiguration build() {
            return new KendraConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KendraConfiguration> {
        public Builder kendraIndex(String var1);

        public Builder queryFilterString(String var1);

        public Builder role(String var1);
    }
}

