/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Intent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Intent> {
    private static final SdkField<String> INTENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("intentName").getter(Intent.getter(Intent::intentName)).setter(Intent.setter(Builder::intentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentName").build()}).build();
    private static final SdkField<String> INTENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("intentVersion").getter(Intent.getter(Intent::intentVersion)).setter(Intent.setter(Builder::intentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTENT_NAME_FIELD, INTENT_VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String intentName;
    private final String intentVersion;

    private Intent(BuilderImpl builder) {
        this.intentName = builder.intentName;
        this.intentVersion = builder.intentVersion;
    }

    public String intentName() {
        return this.intentName;
    }

    public String intentVersion() {
        return this.intentVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.intentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.intentVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Intent)) {
            return false;
        }
        Intent other = (Intent)obj;
        return Objects.equals(this.intentName(), other.intentName()) && Objects.equals(this.intentVersion(), other.intentVersion());
    }

    public String toString() {
        return ToString.builder((String)"Intent").add("IntentName", (Object)this.intentName()).add("IntentVersion", (Object)this.intentVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "intentName": {
                return Optional.ofNullable(clazz.cast(this.intentName()));
            }
            case "intentVersion": {
                return Optional.ofNullable(clazz.cast(this.intentVersion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Intent, T> g) {
        return obj -> g.apply((Intent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String intentName;
        private String intentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(Intent model) {
            this.intentName(model.intentName);
            this.intentVersion(model.intentVersion);
        }

        public final String getIntentName() {
            return this.intentName;
        }

        @Override
        public final Builder intentName(String intentName) {
            this.intentName = intentName;
            return this;
        }

        public final void setIntentName(String intentName) {
            this.intentName = intentName;
        }

        public final String getIntentVersion() {
            return this.intentVersion;
        }

        @Override
        public final Builder intentVersion(String intentVersion) {
            this.intentVersion = intentVersion;
            return this;
        }

        public final void setIntentVersion(String intentVersion) {
            this.intentVersion = intentVersion;
        }

        public Intent build() {
            return new Intent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Intent> {
        public Builder intentName(String var1);

        public Builder intentVersion(String var1);
    }
}

