/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies the specific version of an intent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Intent implements SdkPojo, Serializable, ToCopyableBuilder<Intent.Builder, Intent> {
    private static final SdkField<String> INTENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("intentName").getter(getter(Intent::intentName)).setter(setter(Builder::intentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentName").build()).build();

    private static final SdkField<String> INTENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("intentVersion").getter(getter(Intent::intentVersion)).setter(setter(Builder::intentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTENT_NAME_FIELD,
            INTENT_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String intentName;

    private final String intentVersion;

    private Intent(BuilderImpl builder) {
        this.intentName = builder.intentName;
        this.intentVersion = builder.intentVersion;
    }

    /**
     * <p>
     * The name of the intent.
     * </p>
     * 
     * @return The name of the intent.
     */
    public String intentName() {
        return intentName;
    }

    /**
     * <p>
     * The version of the intent.
     * </p>
     * 
     * @return The version of the intent.
     */
    public String intentVersion() {
        return intentVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(intentName());
        hashCode = 31 * hashCode + Objects.hashCode(intentVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Intent)) {
            return false;
        }
        Intent other = (Intent) obj;
        return Objects.equals(intentName(), other.intentName()) && Objects.equals(intentVersion(), other.intentVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Intent").add("IntentName", intentName()).add("IntentVersion", intentVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "intentName":
            return Optional.ofNullable(clazz.cast(intentName()));
        case "intentVersion":
            return Optional.ofNullable(clazz.cast(intentVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Intent, T> g) {
        return obj -> g.apply((Intent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Intent> {
        /**
         * <p>
         * The name of the intent.
         * </p>
         * 
         * @param intentName
         *        The name of the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentName(String intentName);

        /**
         * <p>
         * The version of the intent.
         * </p>
         * 
         * @param intentVersion
         *        The version of the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentVersion(String intentVersion);
    }

    static final class BuilderImpl implements Builder {
        private String intentName;

        private String intentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(Intent model) {
            intentName(model.intentName);
            intentVersion(model.intentVersion);
        }

        public final String getIntentName() {
            return intentName;
        }

        @Override
        public final Builder intentName(String intentName) {
            this.intentName = intentName;
            return this;
        }

        public final void setIntentName(String intentName) {
            this.intentName = intentName;
        }

        public final String getIntentVersion() {
            return intentVersion;
        }

        @Override
        public final Builder intentVersion(String intentVersion) {
            this.intentVersion = intentVersion;
            return this;
        }

        public final void setIntentVersion(String intentVersion) {
            this.intentVersion = intentVersion;
        }

        @Override
        public Intent build() {
            return new Intent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
