/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a single utterance that was made to your bot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UtteranceData implements SdkPojo, Serializable, ToCopyableBuilder<UtteranceData.Builder, UtteranceData> {
    private static final SdkField<String> UTTERANCE_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("utteranceString").getter(getter(UtteranceData::utteranceString))
            .setter(setter(Builder::utteranceString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("utteranceString").build()).build();

    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("count")
            .getter(getter(UtteranceData::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final SdkField<Integer> DISTINCT_USERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("distinctUsers").getter(getter(UtteranceData::distinctUsers)).setter(setter(Builder::distinctUsers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distinctUsers").build()).build();

    private static final SdkField<Instant> FIRST_UTTERED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("firstUtteredDate").getter(getter(UtteranceData::firstUtteredDate))
            .setter(setter(Builder::firstUtteredDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstUtteredDate").build()).build();

    private static final SdkField<Instant> LAST_UTTERED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUtteredDate").getter(getter(UtteranceData::lastUtteredDate))
            .setter(setter(Builder::lastUtteredDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUtteredDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UTTERANCE_STRING_FIELD,
            COUNT_FIELD, DISTINCT_USERS_FIELD, FIRST_UTTERED_DATE_FIELD, LAST_UTTERED_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String utteranceString;

    private final Integer count;

    private final Integer distinctUsers;

    private final Instant firstUtteredDate;

    private final Instant lastUtteredDate;

    private UtteranceData(BuilderImpl builder) {
        this.utteranceString = builder.utteranceString;
        this.count = builder.count;
        this.distinctUsers = builder.distinctUsers;
        this.firstUtteredDate = builder.firstUtteredDate;
        this.lastUtteredDate = builder.lastUtteredDate;
    }

    /**
     * <p>
     * The text that was entered by the user or the text representation of an audio clip.
     * </p>
     * 
     * @return The text that was entered by the user or the text representation of an audio clip.
     */
    public String utteranceString() {
        return utteranceString;
    }

    /**
     * <p>
     * The number of times that the utterance was processed.
     * </p>
     * 
     * @return The number of times that the utterance was processed.
     */
    public Integer count() {
        return count;
    }

    /**
     * <p>
     * The total number of individuals that used the utterance.
     * </p>
     * 
     * @return The total number of individuals that used the utterance.
     */
    public Integer distinctUsers() {
        return distinctUsers;
    }

    /**
     * <p>
     * The date that the utterance was first recorded.
     * </p>
     * 
     * @return The date that the utterance was first recorded.
     */
    public Instant firstUtteredDate() {
        return firstUtteredDate;
    }

    /**
     * <p>
     * The date that the utterance was last recorded.
     * </p>
     * 
     * @return The date that the utterance was last recorded.
     */
    public Instant lastUtteredDate() {
        return lastUtteredDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(utteranceString());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(distinctUsers());
        hashCode = 31 * hashCode + Objects.hashCode(firstUtteredDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastUtteredDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UtteranceData)) {
            return false;
        }
        UtteranceData other = (UtteranceData) obj;
        return Objects.equals(utteranceString(), other.utteranceString()) && Objects.equals(count(), other.count())
                && Objects.equals(distinctUsers(), other.distinctUsers())
                && Objects.equals(firstUtteredDate(), other.firstUtteredDate())
                && Objects.equals(lastUtteredDate(), other.lastUtteredDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UtteranceData").add("UtteranceString", utteranceString()).add("Count", count())
                .add("DistinctUsers", distinctUsers()).add("FirstUtteredDate", firstUtteredDate())
                .add("LastUtteredDate", lastUtteredDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "utteranceString":
            return Optional.ofNullable(clazz.cast(utteranceString()));
        case "count":
            return Optional.ofNullable(clazz.cast(count()));
        case "distinctUsers":
            return Optional.ofNullable(clazz.cast(distinctUsers()));
        case "firstUtteredDate":
            return Optional.ofNullable(clazz.cast(firstUtteredDate()));
        case "lastUtteredDate":
            return Optional.ofNullable(clazz.cast(lastUtteredDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UtteranceData, T> g) {
        return obj -> g.apply((UtteranceData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UtteranceData> {
        /**
         * <p>
         * The text that was entered by the user or the text representation of an audio clip.
         * </p>
         * 
         * @param utteranceString
         *        The text that was entered by the user or the text representation of an audio clip.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utteranceString(String utteranceString);

        /**
         * <p>
         * The number of times that the utterance was processed.
         * </p>
         * 
         * @param count
         *        The number of times that the utterance was processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * The total number of individuals that used the utterance.
         * </p>
         * 
         * @param distinctUsers
         *        The total number of individuals that used the utterance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distinctUsers(Integer distinctUsers);

        /**
         * <p>
         * The date that the utterance was first recorded.
         * </p>
         * 
         * @param firstUtteredDate
         *        The date that the utterance was first recorded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstUtteredDate(Instant firstUtteredDate);

        /**
         * <p>
         * The date that the utterance was last recorded.
         * </p>
         * 
         * @param lastUtteredDate
         *        The date that the utterance was last recorded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUtteredDate(Instant lastUtteredDate);
    }

    static final class BuilderImpl implements Builder {
        private String utteranceString;

        private Integer count;

        private Integer distinctUsers;

        private Instant firstUtteredDate;

        private Instant lastUtteredDate;

        private BuilderImpl() {
        }

        private BuilderImpl(UtteranceData model) {
            utteranceString(model.utteranceString);
            count(model.count);
            distinctUsers(model.distinctUsers);
            firstUtteredDate(model.firstUtteredDate);
            lastUtteredDate(model.lastUtteredDate);
        }

        public final String getUtteranceString() {
            return utteranceString;
        }

        @Override
        public final Builder utteranceString(String utteranceString) {
            this.utteranceString = utteranceString;
            return this;
        }

        public final void setUtteranceString(String utteranceString) {
            this.utteranceString = utteranceString;
        }

        public final Integer getCount() {
            return count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final Integer getDistinctUsers() {
            return distinctUsers;
        }

        @Override
        public final Builder distinctUsers(Integer distinctUsers) {
            this.distinctUsers = distinctUsers;
            return this;
        }

        public final void setDistinctUsers(Integer distinctUsers) {
            this.distinctUsers = distinctUsers;
        }

        public final Instant getFirstUtteredDate() {
            return firstUtteredDate;
        }

        @Override
        public final Builder firstUtteredDate(Instant firstUtteredDate) {
            this.firstUtteredDate = firstUtteredDate;
            return this;
        }

        public final void setFirstUtteredDate(Instant firstUtteredDate) {
            this.firstUtteredDate = firstUtteredDate;
        }

        public final Instant getLastUtteredDate() {
            return lastUtteredDate;
        }

        @Override
        public final Builder lastUtteredDate(Instant lastUtteredDate) {
            this.lastUtteredDate = lastUtteredDate;
            return this;
        }

        public final void setLastUtteredDate(Instant lastUtteredDate) {
            this.lastUtteredDate = lastUtteredDate;
        }

        @Override
        public UtteranceData build() {
            return new UtteranceData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
