/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelbuilding.model.LogSettingsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.LogSettingsRequestListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConversationLogsRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConversationLogsRequest> {
    private static final SdkField<List<LogSettingsRequest>> LOG_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("logSettings").getter(ConversationLogsRequest.getter(ConversationLogsRequest::logSettings)).setter(ConversationLogsRequest.setter(Builder::logSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LogSettingsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iamRoleArn").getter(ConversationLogsRequest.getter(ConversationLogsRequest::iamRoleArn)).setter(ConversationLogsRequest.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_SETTINGS_FIELD, IAM_ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<LogSettingsRequest> logSettings;
    private final String iamRoleArn;

    private ConversationLogsRequest(BuilderImpl builder) {
        this.logSettings = builder.logSettings;
        this.iamRoleArn = builder.iamRoleArn;
    }

    public boolean hasLogSettings() {
        return this.logSettings != null && !(this.logSettings instanceof SdkAutoConstructList);
    }

    public List<LogSettingsRequest> logSettings() {
        return this.logSettings;
    }

    public String iamRoleArn() {
        return this.iamRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConversationLogsRequest)) {
            return false;
        }
        ConversationLogsRequest other = (ConversationLogsRequest)obj;
        return Objects.equals(this.logSettings(), other.logSettings()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn());
    }

    public String toString() {
        return ToString.builder((String)"ConversationLogsRequest").add("LogSettings", this.logSettings()).add("IamRoleArn", (Object)this.iamRoleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logSettings": {
                return Optional.ofNullable(clazz.cast(this.logSettings()));
            }
            case "iamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConversationLogsRequest, T> g) {
        return obj -> g.apply((ConversationLogsRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<LogSettingsRequest> logSettings = DefaultSdkAutoConstructList.getInstance();
        private String iamRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ConversationLogsRequest model) {
            this.logSettings(model.logSettings);
            this.iamRoleArn(model.iamRoleArn);
        }

        public final Collection<LogSettingsRequest.Builder> getLogSettings() {
            return this.logSettings != null ? (Collection)this.logSettings.stream().map(LogSettingsRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder logSettings(Collection<LogSettingsRequest> logSettings) {
            this.logSettings = LogSettingsRequestListCopier.copy(logSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logSettings(LogSettingsRequest ... logSettings) {
            this.logSettings(Arrays.asList(logSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logSettings(Consumer<LogSettingsRequest.Builder> ... logSettings) {
            this.logSettings(Stream.of(logSettings).map(c -> (LogSettingsRequest)((LogSettingsRequest.Builder)LogSettingsRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLogSettings(Collection<LogSettingsRequest.BuilderImpl> logSettings) {
            this.logSettings = LogSettingsRequestListCopier.copyFromBuilder(logSettings);
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        public ConversationLogsRequest build() {
            return new ConversationLogsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConversationLogsRequest> {
        public Builder logSettings(Collection<LogSettingsRequest> var1);

        public Builder logSettings(LogSettingsRequest ... var1);

        public Builder logSettings(Consumer<LogSettingsRequest.Builder> ... var1);

        public Builder iamRoleArn(String var1);
    }
}

