/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBotAliasResponse extends LexModelBuildingResponse implements
        ToCopyableBuilder<GetBotAliasResponse.Builder, GetBotAliasResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetBotAliasResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetBotAliasResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(GetBotAliasResponse::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<String> BOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botName").getter(getter(GetBotAliasResponse::botName)).setter(setter(Builder::botName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botName").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDate").getter(getter(GetBotAliasResponse::lastUpdatedDate))
            .setter(setter(Builder::lastUpdatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDate").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdDate").getter(getter(GetBotAliasResponse::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()).build();

    private static final SdkField<String> CHECKSUM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("checksum").getter(getter(GetBotAliasResponse::checksum)).setter(setter(Builder::checksum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checksum").build()).build();

    private static final SdkField<ConversationLogsResponse> CONVERSATION_LOGS_FIELD = SdkField
            .<ConversationLogsResponse> builder(MarshallingType.SDK_POJO).memberName("conversationLogs")
            .getter(getter(GetBotAliasResponse::conversationLogs)).setter(setter(Builder::conversationLogs))
            .constructor(ConversationLogsResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationLogs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            BOT_VERSION_FIELD, BOT_NAME_FIELD, LAST_UPDATED_DATE_FIELD, CREATED_DATE_FIELD, CHECKSUM_FIELD,
            CONVERSATION_LOGS_FIELD));

    private final String name;

    private final String description;

    private final String botVersion;

    private final String botName;

    private final Instant lastUpdatedDate;

    private final Instant createdDate;

    private final String checksum;

    private final ConversationLogsResponse conversationLogs;

    private GetBotAliasResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.botVersion = builder.botVersion;
        this.botName = builder.botName;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.createdDate = builder.createdDate;
        this.checksum = builder.checksum;
        this.conversationLogs = builder.conversationLogs;
    }

    /**
     * <p>
     * The name of the bot alias.
     * </p>
     * 
     * @return The name of the bot alias.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A description of the bot alias.
     * </p>
     * 
     * @return A description of the bot alias.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The version of the bot that the alias points to.
     * </p>
     * 
     * @return The version of the bot that the alias points to.
     */
    public String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The name of the bot that the alias points to.
     * </p>
     * 
     * @return The name of the bot that the alias points to.
     */
    public String botName() {
        return botName;
    }

    /**
     * <p>
     * The date that the bot alias was updated. When you create a resource, the creation date and the last updated date
     * are the same.
     * </p>
     * 
     * @return The date that the bot alias was updated. When you create a resource, the creation date and the last
     *         updated date are the same.
     */
    public Instant lastUpdatedDate() {
        return lastUpdatedDate;
    }

    /**
     * <p>
     * The date that the bot alias was created.
     * </p>
     * 
     * @return The date that the bot alias was created.
     */
    public Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * Checksum of the bot alias.
     * </p>
     * 
     * @return Checksum of the bot alias.
     */
    public String checksum() {
        return checksum;
    }

    /**
     * <p>
     * The settings that determine how Amazon Lex uses conversation logs for the alias.
     * </p>
     * 
     * @return The settings that determine how Amazon Lex uses conversation logs for the alias.
     */
    public ConversationLogsResponse conversationLogs() {
        return conversationLogs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(botName());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(checksum());
        hashCode = 31 * hashCode + Objects.hashCode(conversationLogs());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBotAliasResponse)) {
            return false;
        }
        GetBotAliasResponse other = (GetBotAliasResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(botVersion(), other.botVersion()) && Objects.equals(botName(), other.botName())
                && Objects.equals(lastUpdatedDate(), other.lastUpdatedDate())
                && Objects.equals(createdDate(), other.createdDate()) && Objects.equals(checksum(), other.checksum())
                && Objects.equals(conversationLogs(), other.conversationLogs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetBotAliasResponse").add("Name", name()).add("Description", description())
                .add("BotVersion", botVersion()).add("BotName", botName()).add("LastUpdatedDate", lastUpdatedDate())
                .add("CreatedDate", createdDate()).add("Checksum", checksum()).add("ConversationLogs", conversationLogs())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "botName":
            return Optional.ofNullable(clazz.cast(botName()));
        case "lastUpdatedDate":
            return Optional.ofNullable(clazz.cast(lastUpdatedDate()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "checksum":
            return Optional.ofNullable(clazz.cast(checksum()));
        case "conversationLogs":
            return Optional.ofNullable(clazz.cast(conversationLogs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBotAliasResponse, T> g) {
        return obj -> g.apply((GetBotAliasResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelBuildingResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetBotAliasResponse> {
        /**
         * <p>
         * The name of the bot alias.
         * </p>
         * 
         * @param name
         *        The name of the bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the bot alias.
         * </p>
         * 
         * @param description
         *        A description of the bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The version of the bot that the alias points to.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot that the alias points to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The name of the bot that the alias points to.
         * </p>
         * 
         * @param botName
         *        The name of the bot that the alias points to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botName(String botName);

        /**
         * <p>
         * The date that the bot alias was updated. When you create a resource, the creation date and the last updated
         * date are the same.
         * </p>
         * 
         * @param lastUpdatedDate
         *        The date that the bot alias was updated. When you create a resource, the creation date and the last
         *        updated date are the same.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(Instant lastUpdatedDate);

        /**
         * <p>
         * The date that the bot alias was created.
         * </p>
         * 
         * @param createdDate
         *        The date that the bot alias was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * Checksum of the bot alias.
         * </p>
         * 
         * @param checksum
         *        Checksum of the bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checksum(String checksum);

        /**
         * <p>
         * The settings that determine how Amazon Lex uses conversation logs for the alias.
         * </p>
         * 
         * @param conversationLogs
         *        The settings that determine how Amazon Lex uses conversation logs for the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationLogs(ConversationLogsResponse conversationLogs);

        /**
         * <p>
         * The settings that determine how Amazon Lex uses conversation logs for the alias.
         * </p>
         * This is a convenience that creates an instance of the {@link ConversationLogsResponse.Builder} avoiding the
         * need to create one manually via {@link ConversationLogsResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConversationLogsResponse.Builder#build()} is called immediately
         * and its result is passed to {@link #conversationLogs(ConversationLogsResponse)}.
         * 
         * @param conversationLogs
         *        a consumer that will call methods on {@link ConversationLogsResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conversationLogs(ConversationLogsResponse)
         */
        default Builder conversationLogs(Consumer<ConversationLogsResponse.Builder> conversationLogs) {
            return conversationLogs(ConversationLogsResponse.builder().applyMutation(conversationLogs).build());
        }
    }

    static final class BuilderImpl extends LexModelBuildingResponse.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String botVersion;

        private String botName;

        private Instant lastUpdatedDate;

        private Instant createdDate;

        private String checksum;

        private ConversationLogsResponse conversationLogs;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBotAliasResponse model) {
            super(model);
            name(model.name);
            description(model.description);
            botVersion(model.botVersion);
            botName(model.botName);
            lastUpdatedDate(model.lastUpdatedDate);
            createdDate(model.createdDate);
            checksum(model.checksum);
            conversationLogs(model.conversationLogs);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        public final String getBotName() {
            return botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        public final Instant getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final String getChecksum() {
            return checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public final ConversationLogsResponse.Builder getConversationLogs() {
            return conversationLogs != null ? conversationLogs.toBuilder() : null;
        }

        @Override
        public final Builder conversationLogs(ConversationLogsResponse conversationLogs) {
            this.conversationLogs = conversationLogs;
            return this;
        }

        public final void setConversationLogs(ConversationLogsResponse.BuilderImpl conversationLogs) {
            this.conversationLogs = conversationLogs != null ? conversationLogs.build() : null;
        }

        @Override
        public GetBotAliasResponse build() {
            return new GetBotAliasResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
