/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Locale {
    DE_DE("de-DE"),
    EN_AU("en-AU"),
    EN_GB("en-GB"),
    EN_US("en-US"),
    ES_419("es-419"),
    ES_ES("es-ES"),
    ES_US("es-US"),
    FR_FR("fr-FR"),
    FR_CA("fr-CA"),
    IT_IT("it-IT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Locale(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Locale fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Locale.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Locale> knownValues() {
        return Stream.of(Locale.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

